/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.n52.io.geojson.FeatureOutputSerializer;
import org.n52.io.geojson.GeoJSONFeature;
import org.n52.io.geojson.GeoJSONObject;
import org.n52.io.response.AbstractOutput;
import org.n52.io.response.GeometryType;
import org.n52.io.response.OptionalOutput;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.ServiceOutput;

@JsonSerialize(using=FeatureOutputSerializer.class, as=GeoJSONObject.class)
public class GeometryOutput
extends AbstractOutput
implements GeoJSONFeature {
    public static final String COLLECTION_PATH = "geometries";
    public static final String PROPERTIES = "properties";
    public static final String GEOMETRY_TYPE = "geometryType";
    public static final String PLATFORM = "platform";
    private OptionalOutput<GeometryType> geometryType;
    private OptionalOutput<PlatformOutput> platform;
    private OptionalOutput<Geometry> geometry;

    @Override
    protected String getCollectionName() {
        return COLLECTION_PATH;
    }

    @Override
    public String getId() {
        GeometryType type = this.getIfSet(this.geometryType, true);
        return type.createId(super.getId());
    }

    public GeometryOutput setGeometryType(OptionalOutput<GeometryType> geometryType) {
        this.geometryType = geometryType;
        return this;
    }

    @Override
    public String getLabel() {
        return super.getLabel();
    }

    @Override
    public String getDomainId() {
        return super.getDomainId();
    }

    @Override
    public ServiceOutput getService() {
        return super.getService();
    }

    public PlatformOutput getPlatform() {
        return this.getIfSerialized(this.platform);
    }

    public GeometryOutput setPlatform(OptionalOutput<PlatformOutput> platform) {
        this.platform = platform;
        return this;
    }

    @Override
    public Geometry getGeometry() {
        return this.getIfSet(this.geometry, true);
    }

    @Override
    public void setGeometry(OptionalOutput<Geometry> geometry) {
        this.geometry = geometry;
    }

    @Override
    public boolean isSetGeometry() {
        return this.getIfSerialized(this.geometry) != null && !this.getGeometry().isEmpty();
    }

    @Override
    public String getHrefBase() {
        String base = super.getHrefBase();
        String suffix = this.getUrlIdPrefix();
        return base != null && base.endsWith(suffix) ? base.substring(0, base.lastIndexOf(suffix) - 1) : base;
    }

    public GeometryType getType() {
        return this.getIfSerialized(this.geometryType);
    }

    private String getUrlIdPrefix() {
        return this.getIfSet(this.geometryType, true).getGeometryType();
    }

    public String getGeometryType() {
        return this.getIfSerialized(this.geometryType) != null ? this.getType().getGeometryType() : null;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.nullSafePut(GEOMETRY_TYPE, this.getGeometryType(), properties);
        this.nullSafePut(PLATFORM, this.getPlatform(), properties);
        this.nullSafePut("href", this.getHref(), properties);
        return properties;
    }

    private void nullSafePut(String key, Object value, Map<String, Object> container) {
        if (value != null) {
            container.put(key, value);
        }
    }
}

