/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.n52.io.response.ParameterOutput;

public class OutputCollection<T extends ParameterOutput>
implements Iterable<T> {
    private final List<T> items;

    protected OutputCollection() {
        this(new ArrayList());
    }

    public OutputCollection(List<T> items) {
        this.items = new ArrayList<T>(items);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public final void addItem(T item) {
        this.items.add(item);
    }

    public final void addItems(Collection<T> toAdd) {
        this.items.addAll(toAdd);
    }

    public void removeItem(T item) {
        this.items.remove(item);
    }

    public T getItem(int i) {
        return (T)((ParameterOutput)this.items.get(i));
    }

    public List<T> getItems() {
        Collections.sort(this.items, this.getComparator());
        return Collections.unmodifiableList(this.items);
    }

    public int size() {
        return this.items.size();
    }

    protected Comparator<T> getComparator() {
        return ParameterOutput.defaultComparator();
    }

    public boolean containsItem(T item) {
        return this.items.contains(item);
    }

    public Stream<T> stream() {
        return this.items.stream();
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }
}

