/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.locationtech.jts.geom.Geometry;
import org.n52.io.geojson.GeoJSONGeometrySerializer;
import org.n52.io.response.TimeOutput;
import org.n52.io.response.TimeOutputConverter;
import org.n52.io.response.dataset.ValueFormatter;

public abstract class AbstractValue<T>
implements Comparable<AbstractValue<T>>,
Serializable {
    private static final long serialVersionUID = -1606015864495830281L;
    private TimeOutput timestart;
    private TimeOutput timestamp;
    private T value;
    private ValueFormatter<T> valueFormatter;
    private Geometry geometry;
    private Set<Map<String, Object>> parameters;
    private ValidTime validTime;
    private DateTime resultTime;

    public AbstractValue() {
    }

    public AbstractValue(TimeOutput timestamp, T value) {
        this(null, timestamp, value);
    }

    public AbstractValue(TimeOutput timestart, TimeOutput timeend, T value) {
        this.timestart = timestart;
        this.timestamp = timeend;
        this.value = value;
    }

    @JsonSerialize(converter=TimeOutputConverter.class)
    public TimeOutput getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(TimeOutput timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public boolean isSetTimestamp() {
        return !this.isSetTimestart() || this.isSetTimestart() && this.timestart.equals(this.timestamp);
    }

    @JsonSerialize(converter=TimeOutputConverter.class)
    public TimeOutput getTimeend() {
        return this.isSetTimestart() ? this.timestamp : null;
    }

    @JsonIgnore
    public boolean isSetTimeend() {
        return this.timestamp != null && this.isSetTimestart();
    }

    @JsonSerialize(converter=TimeOutputConverter.class)
    public TimeOutput getTimestart() {
        return this.timestart;
    }

    public void setTimestart(TimeOutput timestart) {
        this.timestart = timestart;
    }

    @JsonIgnore
    public boolean isSetTimestart() {
        return this.timestart != null;
    }

    @JsonIgnore
    public boolean isNoDataValue() {
        return this.value == null;
    }

    @JsonInclude(content=JsonInclude.Include.ALWAYS)
    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @JsonIgnore
    public void setValueFormatter(ValueFormatter<T> valueFormatter) {
        this.valueFormatter = valueFormatter;
    }

    @JsonIgnore
    public String getFormattedValue() {
        if (this.value == null) {
            return null;
        }
        return this.valueFormatter != null ? this.valueFormatter.format(this.value) : this.value.toString();
    }

    @JsonSerialize(using=GeoJSONGeometrySerializer.class)
    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    @JsonIgnore
    public boolean isSetGeometry() {
        return this.geometry != null && !this.geometry.isEmpty();
    }

    public void setParameters(Set<Map<String, Object>> parameters) {
        this.parameters = new HashSet<Map<String, Object>>(parameters);
    }

    public Set<Map<String, Object>> getParameters() {
        return this.parameters != null ? Collections.unmodifiableSet(this.parameters) : null;
    }

    public void addParameter(Map<String, Object> parameterValue) {
        if (this.parameters == null) {
            this.parameters = new HashSet<Map<String, Object>>();
        }
        this.parameters.add(parameterValue);
    }

    public ValidTime getValidTime() {
        return this.validTime;
    }

    public void setValidTime(ValidTime validTime) {
        this.validTime = validTime;
    }

    public void setValidTime(TimeOutput start, TimeOutput end) {
        this.validTime = new ValidTime(start, end);
    }

    @JsonIgnore
    public DateTime getResultTime() {
        return this.resultTime;
    }

    public void setResultTime(DateTime resultTime) {
        this.resultTime = resultTime;
    }

    @Override
    public int compareTo(AbstractValue<T> o) {
        return this.getTimestamp().compareTo(o.getTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        return sb.append(" [ ").append("timestart: ").append(this.getTimestart()).append(", ").append("timestamp: ").append(this.getTimestamp()).append(", ").append("value: ").append(this.getValue()).append(" ]").toString();
    }

    public class ValidTime {
        private TimeOutput start;
        private TimeOutput end;

        public ValidTime(TimeOutput start, TimeOutput end) {
            this.start = start;
            this.end = end;
        }

        @JsonSerialize(converter=TimeOutputConverter.class)
        public TimeOutput getStart() {
            return this.start;
        }

        public void setStart(TimeOutput start) {
            this.start = start;
        }

        @JsonSerialize(converter=TimeOutputConverter.class)
        public TimeOutput getEnd() {
            return this.end;
        }

        public void setEnd(TimeOutput end) {
            this.end = end;
        }
    }
}

