/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import org.n52.io.request.IoParameters;
import org.n52.io.response.FeatureOutput;
import org.n52.io.response.OptionalOutput;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.TimeOutput;
import org.n52.io.response.TimeOutputConverter;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.ReferenceValueOutput;

public class DatasetOutput<V extends AbstractValue<?>>
extends ParameterOutput {
    public static final String COLLECTION_PATH = "datasets";
    public static final String DATASET_TYPE = "datasetType";
    public static final String OBSERVATION_TYPE = "observationType";
    public static final String VALUE_TYPE = "valueType";
    public static final String MOBILE = "mobile";
    public static final String INSITU = "insitu";
    public static final String UOM = "uom";
    public static final String DATASET_PARAMETERS = "parameters";
    public static final String ORIGIN_TIMEZONE = "originTimezone";
    public static final String SMAPLING_TIME_START = "samplingTimeStart";
    public static final String SMAPLING_TIME_END = "samplingTimeEnd";
    public static final String FEATURE = "feature";
    public static final String REFERENCE_VALUES = "referenceValues";
    public static final String FIRST_VALUE = "firstValue";
    public static final String LAST_VALUE = "lastValue";
    private OptionalOutput<String> datasetType;
    private OptionalOutput<String> observationType;
    private OptionalOutput<String> valueType;
    private OptionalOutput<Boolean> mobile;
    private OptionalOutput<Boolean> insitu;
    private OptionalOutput<String> uom;
    private OptionalOutput<String> originTimezone;
    private OptionalOutput<TimeOutput> samplingTimeStart;
    private OptionalOutput<TimeOutput> samplingTimeEnd;
    private OptionalOutput<FeatureOutput> feature;
    private OptionalOutput<DatasetParameters> datasetParameters;
    private OptionalOutput<List<ReferenceValueOutput<V>>> referenceValues;
    private OptionalOutput<V> firstValue;
    private OptionalOutput<V> lastValue;

    protected DatasetOutput() {
    }

    public String getDatasetType() {
        return this.getIfSerialized(this.datasetType);
    }

    public void setDatasetType(OptionalOutput<String> datasetType) {
        this.datasetType = datasetType;
    }

    public String getObservationType() {
        return this.getIfSerialized(this.observationType);
    }

    public DatasetOutput<?> setObservationType(OptionalOutput<String> observationType) {
        this.observationType = observationType;
        return this;
    }

    public String getValueType() {
        return this.getIfSerialized(this.valueType);
    }

    public void setValueType(OptionalOutput<String> valueType) {
        this.valueType = valueType;
    }

    public Boolean getMobile() {
        return this.getIfSerialized(this.mobile);
    }

    public DatasetOutput<V> setMobile(OptionalOutput<Boolean> mobile) {
        this.mobile = mobile;
        return this;
    }

    public Boolean getInsitu() {
        return this.getIfSerialized(this.insitu);
    }

    public DatasetOutput<V> setInsitu(OptionalOutput<Boolean> insitu) {
        this.insitu = insitu;
        return this;
    }

    public String getUom() {
        return this.getIfSerialized(this.uom);
    }

    public DatasetOutput<?> setUom(OptionalOutput<String> uom) {
        this.uom = uom;
        return this;
    }

    public String getOriginTimezone() {
        return this.getIfSerialized(this.originTimezone);
    }

    public void setOriginTimezone(OptionalOutput<String> originTimezone) {
        this.originTimezone = originTimezone;
    }

    @JsonSerialize(converter=TimeOutputConverter.class)
    public TimeOutput getSamplingTmeStart() {
        return this.getIfSerialized(this.samplingTimeStart);
    }

    public void setSamplingTimeStart(OptionalOutput<TimeOutput> samplingTimeStart) {
        this.samplingTimeStart = samplingTimeStart;
    }

    @JsonSerialize(converter=TimeOutputConverter.class)
    public TimeOutput getSamplingTimeEnd() {
        return this.getIfSerialized(this.samplingTimeEnd);
    }

    public void setSamplingTimeEnd(OptionalOutput<TimeOutput> samplingTimeEnd) {
        this.samplingTimeEnd = samplingTimeEnd;
    }

    public FeatureOutput getFeature() {
        return this.getIfSerialized(this.feature);
    }

    public void setFeature(OptionalOutput<FeatureOutput> feature) {
        this.feature = feature;
    }

    public DatasetParameters getDatasetParameters(boolean forced) {
        return this.getIfSet(this.datasetParameters, forced);
    }

    @JsonProperty(value="parameters")
    public DatasetParameters getDatasetParameters() {
        return this.getDatasetParameters(false);
    }

    public DatasetOutput<?> setDatasetParameters(OptionalOutput<DatasetParameters> parameters) {
        this.datasetParameters = parameters;
        return this;
    }

    @Override
    protected String getCollectionName() {
        return COLLECTION_PATH;
    }

    public static <V extends AbstractValue<?>> DatasetOutput<V> create(IoParameters params) {
        DatasetOutput<V> output = new DatasetOutput<V>();
        return output;
    }

    public V getFirstValue() {
        return (V)((AbstractValue)this.getIfSerialized(this.firstValue));
    }

    public DatasetOutput<V> setFirstValue(OptionalOutput<V> firstValue) {
        this.firstValue = firstValue;
        return this;
    }

    public V getLastValue() {
        return (V)((AbstractValue)this.getIfSerialized(this.lastValue));
    }

    public DatasetOutput<V> setLastValue(OptionalOutput<V> lastValue) {
        this.lastValue = lastValue;
        return this;
    }

    public List<ReferenceValueOutput<V>> getReferenceValues() {
        return this.getIfSerializedCollection(this.referenceValues);
    }

    public DatasetOutput<V> setReferenceValues(OptionalOutput<List<ReferenceValueOutput<V>>> referenceValues) {
        this.referenceValues = referenceValues;
        return this;
    }
}

