/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset.profile;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Objects;
import org.n52.io.response.dataset.ValueFormatter;

@JsonPropertyOrder(value={"verticalFrom", "verticalTo", "vertical", "value"})
public class ProfileDataItem<T>
implements Comparable<ProfileDataItem<T>> {
    private BigDecimal verticalFrom;
    private BigDecimal vertical;
    private T value;
    private ValueFormatter<T> valueFormatter;

    public ProfileDataItem() {
    }

    public ProfileDataItem(BigDecimal vertical, T value) {
        this(null, vertical, value);
    }

    public ProfileDataItem(BigDecimal verticalFrom, BigDecimal verticalTo, T value) {
        this.verticalFrom = verticalFrom;
        this.vertical = verticalTo;
        this.value = value;
    }

    public BigDecimal getVerticalFrom() {
        return this.verticalFrom;
    }

    @JsonFormat(shape=JsonFormat.Shape.NUMBER_FLOAT)
    public void setVerticalFrom(BigDecimal verticalFrom) {
        this.verticalFrom = verticalFrom;
    }

    private boolean isSetVerticalFrom() {
        return this.verticalFrom != null;
    }

    @JsonFormat(shape=JsonFormat.Shape.NUMBER_FLOAT)
    public BigDecimal getVerticalTo() {
        return this.isSetVerticalFrom() ? this.vertical : null;
    }

    @JsonFormat(shape=JsonFormat.Shape.NUMBER_FLOAT)
    public BigDecimal getVertical() {
        return !this.isSetVerticalFrom() ? this.vertical : null;
    }

    public void setVertical(BigDecimal vertical) {
        this.vertical = vertical;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @JsonIgnore
    public void setValueFormatter(ValueFormatter<T> valueFormatter) {
        this.valueFormatter = valueFormatter;
    }

    @JsonIgnore
    public String getFormattedValue() {
        if (this.value == null) {
            return null;
        }
        return this.valueFormatter != null ? this.valueFormatter.format(this.value) : this.value.toString();
    }

    @Override
    public int compareTo(ProfileDataItem<T> o) {
        if (this.isSetVerticalFrom() && super.isSetVerticalFrom()) {
            return Comparator.comparing(ProfileDataItem::getVerticalFrom).thenComparing(ProfileDataItem::getVerticalTo).compare(this, o);
        }
        if (this.getVertical() != null) {
            if (o.getVertical() != null) {
                return Comparator.comparing(ProfileDataItem::getVertical).compare(this, o);
            }
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.vertical, this.verticalFrom, this.vertical);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProfileDataItem)) {
            return false;
        }
        ProfileDataItem other = (ProfileDataItem)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.vertical, other.vertical) && Objects.equals(this.verticalFrom, other.verticalFrom) && Objects.equals(this.vertical, other.vertical);
    }
}

