/*
 * Copyright 2015-2018 52°North Initiative for Geospatial Open Source
 * Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.n52.series.db.beans.parameter;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.n52.series.db.beans.IdEntity;

public abstract class Parameter<T> extends IdEntity implements ValuedParameter<T, Parameter<T>> {

    private static final long serialVersionUID = -1489503368673412638L;

    private String name;

    private Date lastUpdate;

    private String domain;

    private T value;

    public Map<String, Object> toValueMap(String locale) {
        Map<String, Object> valueMap = new HashMap<>();
        valueMap.put("name", getName());
        valueMap.put("value", getValue());
        return valueMap;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isSetName() {
        return getName() != null && !getName().isEmpty();
    }

    public Date getLastUpdate() {
        return lastUpdate != null
                ? new Timestamp(lastUpdate.getTime())
                : null;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate != null
                ? new Timestamp(lastUpdate.getTime())
                : null;
    }

    public boolean isSetLastUpdate() {
        return getLastUpdate() != null;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isSetDomain() {
        return getDomain() != null && !getDomain().isEmpty();
    }

    @Override
    public T getValue() {
        return value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public boolean isSetValue() {
        return getValue() != null;
    }

}
