/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.sql.Timestamp;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.junit.Test;
import org.n52.series.db.beans.CountDatasetEntity;

public class DatasetEntityTest {
    @Test
    public void when_settingFirstValueAtWithNanos_then_nanosAvailableOnGetting() {
        CountDatasetEntity datasetEntity = new CountDatasetEntity();
        Timestamp timestamp = this.createTimestamp("2015-07-17T21:14:35.022+02", 321);
        datasetEntity.setFirstValueAt((Date)timestamp);
        Timestamp firstValueAt = (Timestamp)datasetEntity.getFirstValueAt();
        MatcherAssert.assertThat((Object)firstValueAt.getNanos(), (Matcher)CoreMatchers.is((Object)timestamp.getNanos()));
    }

    @Test
    public void when_settingLastValueAtWithNanos_then_nanosAvailableOnGetting() {
        CountDatasetEntity datasetEntity = new CountDatasetEntity();
        Timestamp timestamp = this.createTimestamp("2015-07-17T21:14:35.022+02", 321);
        datasetEntity.setLastValueAt((Date)timestamp);
        Timestamp lastValueAt = (Timestamp)datasetEntity.getLastValueAt();
        MatcherAssert.assertThat((Object)lastValueAt.getNanos(), (Matcher)CoreMatchers.is((Object)timestamp.getNanos()));
    }

    private Timestamp createTimestamp(String date, int nanos) {
        DateTime timeValue = DateTime.parse((String)date);
        Timestamp timestamp = new Timestamp(timeValue.getMillis());
        timestamp.setNanos(nanos);
        return timestamp;
    }
}

