/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.IdEntity;
import org.n52.series.db.beans.RelatedDataEntity;
import org.n52.series.db.beans.data.Data;
import org.n52.series.db.beans.parameter.Parameter;
import org.n52.series.db.common.Utils;

public abstract class DataEntity<T>
extends DescribableEntity
implements Comparable<DataEntity<T>>,
Serializable,
Data<T> {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_RESULT_TIME = "resultTime";
    public static final String PROPERTY_SAMPLING_TIME_START = "samplingTimeStart";
    public static final String PROPERTY_SAMPLING_TIME_END = "samplingTimeEnd";
    public static final String PROPERTY_VALID_TIME_START = "valid_time_start";
    public static final String PROPERTY_VALID_TIME_END = "valid_time_end";
    public static final String PROPERTY_GEOMETRY_ENTITY = "geometryEntity";
    public static final String PROPERTY_DELETED = "deleted";
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_IDENTIFIER = "identifier";
    public static final String PROPERTY_CHILD = "child";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_PARAMETERS = "parameters";
    private static final long serialVersionUID = 273612846605300612L;
    private Date samplingTimeStart;
    private Date samplingTimeEnd;
    private T value;
    private GeometryEntity geometryEntity;
    private boolean deleted;
    private Date validTimeStart;
    private Date validTimeEnd;
    private Date resultTime;
    private boolean parent;
    private boolean child;
    private DatasetEntity dataset;
    private Set<Parameter<?>> parameters = new HashSet(0);
    private Set<RelatedDataEntity> relatedObservations = new HashSet<RelatedDataEntity>(0);
    private String valueIdentifier;
    private String valueName;
    private String valueDescription;
    private BigDecimal verticalFrom = NOT_SET_VERTICAL;
    private BigDecimal verticalTo = NOT_SET_VERTICAL;

    protected DataEntity() {
    }

    @Override
    public Date getSamplingTimeStart() {
        return Utils.createUnmutableTimestamp(this.samplingTimeStart);
    }

    @Override
    public void setSamplingTimeStart(Date samplingTimeStart) {
        this.samplingTimeStart = Utils.createUnmutableTimestamp(samplingTimeStart);
    }

    @Override
    public Date getSamplingTimeEnd() {
        return Utils.createUnmutableTimestamp(this.samplingTimeEnd);
    }

    @Override
    public void setSamplingTimeEnd(Date samplingTimeEnd) {
        this.samplingTimeEnd = Utils.createUnmutableTimestamp(samplingTimeEnd);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public boolean hasValue() {
        return this.getValue() != null;
    }

    @Override
    public abstract boolean isNoDataValue(Collection<String> var1);

    @Override
    public GeometryEntity getGeometryEntity() {
        return this.geometryEntity;
    }

    @Override
    public void setGeometryEntity(GeometryEntity geometryEntity) {
        this.geometryEntity = geometryEntity;
    }

    @Override
    public boolean isSetGeometryEntity() {
        return this.geometryEntity != null && !this.geometryEntity.isEmpty();
    }

    @Override
    public boolean getDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public Date getValidTimeStart() {
        return Utils.createUnmutableTimestamp(this.validTimeStart);
    }

    @Override
    public void setValidTimeStart(Date validTimeStart) {
        this.validTimeStart = Utils.createUnmutableTimestamp(validTimeStart);
    }

    @Override
    public Date getValidTimeEnd() {
        return Utils.createUnmutableTimestamp(this.validTimeEnd);
    }

    @Override
    public void setValidTimeEnd(Date validTimeEnd) {
        this.validTimeEnd = Utils.createUnmutableTimestamp(validTimeEnd);
    }

    @Override
    public boolean isSetValidTime() {
        return this.isSetValidStartTime() && this.isSetValidEndTime();
    }

    @Override
    public boolean isSetValidStartTime() {
        return this.validTimeStart != null;
    }

    @Override
    public boolean isSetValidEndTime() {
        return this.validTimeEnd != null;
    }

    @Override
    public Date getResultTime() {
        return Utils.createUnmutableTimestamp(this.resultTime);
    }

    @Override
    public void setResultTime(Date resultTime) {
        this.resultTime = Utils.createUnmutableTimestamp(resultTime);
    }

    @Override
    public boolean isParent() {
        return this.parent;
    }

    @Override
    public void setParent(boolean parent) {
        this.parent = parent;
    }

    @Override
    public boolean isChild() {
        return this.child;
    }

    @Override
    public void setChild(boolean child) {
        this.child = child;
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Set<Parameter<?>> parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean hasParameters() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    @Override
    public DatasetEntity getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(DatasetEntity dataset) {
        this.dataset = dataset;
    }

    @Override
    public Set<RelatedDataEntity> getRelatedObservations() {
        return this.relatedObservations;
    }

    @Override
    public void setRelatedObservations(Set<RelatedDataEntity> relatedObservations) {
        this.relatedObservations = relatedObservations;
    }

    @Override
    public boolean hasRelatedObservations() {
        return this.getRelatedObservations() != null && !this.getRelatedObservations().isEmpty();
    }

    @Override
    public String getValueIdentifier() {
        return this.valueIdentifier;
    }

    @Override
    public void setValueIdentifier(String valueIdentifier) {
        this.valueIdentifier = valueIdentifier;
    }

    @Override
    public boolean hasValueIdentifier() {
        return this.getValueIdentifier() != null && !this.getValueIdentifier().isEmpty();
    }

    @Override
    public String getValueName() {
        return this.valueName;
    }

    @Override
    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    @Override
    public boolean hasValueName() {
        return this.getValueName() != null && !this.getValueName().isEmpty();
    }

    @Override
    public String getValueDescription() {
        return this.valueDescription;
    }

    @Override
    public void setValueDescription(String valueDescription) {
        this.valueDescription = valueDescription;
    }

    @Override
    public boolean hasValueDescription() {
        return this.getValueDescription() != null && !this.getValueDescription().isEmpty();
    }

    @Override
    public BigDecimal getVerticalFrom() {
        return this.verticalFrom;
    }

    @Override
    public void setVerticalFrom(BigDecimal verticalFrom) {
        this.verticalFrom = verticalFrom;
    }

    @Override
    public BigDecimal getVerticalTo() {
        return this.verticalTo;
    }

    @Override
    public void setVerticalTo(BigDecimal verticalTo) {
        this.verticalTo = verticalTo;
    }

    @Override
    public int compareTo(DataEntity<T> o) {
        return Comparator.comparing(DataEntity::getSamplingTimeEnd).thenComparing(DataEntity::getSamplingTimeStart).thenComparing(IdEntity::getId).compare(this, o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataEntity other = (DataEntity)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" id: ").append(this.getId()).append(" ]").toString();
    }
}

