/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FormatEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.RelatedDatasetEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.beans.data.Data;
import org.n52.series.db.beans.dataset.Dataset;
import org.n52.series.db.common.Utils;

public abstract class DatasetEntity
extends DescribableEntity
implements Serializable,
Dataset {
    public static final String ENTITY_ALIAS = "dataset";
    public static final String PROPERTY_OFFERING = "offering";
    public static final String PROPERTY_PROCEDURE = "procedure";
    public static final String PROPERTY_PHENOMENON = "phenomenon";
    public static final String PROPERTY_CATEGORY = "category";
    public static final String PROPERTY_FEATURE = "feature";
    public static final String PROPERTY_VALUE_TYPE = "valueType";
    public static final String PROPERTY_FIRST_VALUE_AT = "firstValueAt";
    public static final String PROPERTY_LAST_VALUE_AT = "lastValueAt";
    public static final String PROPERTY_PUBLISHED = "published";
    public static final String PROPERTY_DELETED = "deleted";
    public static final String HIDDEN_CHILD = "hidden";
    public static final String PROPERTY_UNIT = "unit";
    private static final long serialVersionUID = -7491530543976690237L;
    private PhenomenonEntity phenomenon;
    private ProcedureEntity procedure;
    private OfferingEntity offering;
    private AbstractFeatureEntity feature;
    private CategoryEntity category;
    private PlatformEntity platform;
    private boolean published = true;
    private boolean deleted;
    private boolean disabled;
    private String valueType;
    private Set<Date> resultTimes;
    private Date firstValueAt;
    private Date lastValueAt;
    private Data firstObservation;
    private Data lastObservation;
    private BigDecimal firstQuantityValue;
    private BigDecimal lastQuantityValue;
    private UnitEntity unit;
    private long observationCount = -1L;
    private boolean hidden;
    private FormatEntity observationType;
    private boolean mobile;
    private boolean insitu = true;
    private String originTimezone;
    private final Set<RelatedDatasetEntity> relatedDatasets = new LinkedHashSet<RelatedDatasetEntity>();

    public DatasetEntity() {
        this(null);
    }

    public DatasetEntity(String type) {
        this.valueType = type;
    }

    @Override
    public CategoryEntity getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(CategoryEntity category) {
        this.category = category;
    }

    @Override
    public PhenomenonEntity getPhenomenon() {
        return this.phenomenon;
    }

    @Override
    public DatasetEntity setPhenomenon(PhenomenonEntity phenomenon) {
        this.phenomenon = phenomenon;
        return this;
    }

    @Override
    public PhenomenonEntity getObservableProperty() {
        return this.getPhenomenon();
    }

    @Override
    public DatasetEntity setObservableProperty(PhenomenonEntity observableProperty) {
        return this.setPhenomenon(observableProperty);
    }

    @Override
    public ProcedureEntity getProcedure() {
        return this.procedure;
    }

    @Override
    public DatasetEntity setProcedure(ProcedureEntity procedure) {
        this.procedure = procedure;
        return this;
    }

    @Override
    public OfferingEntity getOffering() {
        return this.offering;
    }

    @Override
    public DatasetEntity setOffering(OfferingEntity offering) {
        this.offering = offering;
        return this;
    }

    @Override
    public boolean isSetOffering() {
        return this.getOffering() != null;
    }

    @Override
    public AbstractFeatureEntity getFeature() {
        return this.feature;
    }

    @Override
    public void setFeature(AbstractFeatureEntity feature) {
        this.feature = feature;
    }

    @Override
    public boolean isSetFeature() {
        return this.getFeature() != null;
    }

    @Override
    public PlatformEntity getPlatform() {
        return this.platform;
    }

    @Override
    public void setPlatform(PlatformEntity platform) {
        this.platform = platform;
    }

    @Override
    public Boolean isPublished() {
        return this.published;
    }

    @Override
    public void setPublished(boolean published) {
        this.published = published;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public DatasetEntity setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    public boolean getDeleted() {
        return this.deleted;
    }

    @Override
    public DatasetEntity setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isSetObservationType() {
        return this.getObservationType() != null && this.getObservationType().isSetFormat();
    }

    @Override
    public Date getFirstValueAt() {
        return Utils.createUnmutableTimestamp(this.firstValueAt);
    }

    @Override
    public void setFirstValueAt(Date firstValueAt) {
        this.firstValueAt = Utils.createUnmutableTimestamp(firstValueAt);
    }

    @Override
    public boolean isSetFirstValueAt() {
        return this.getFirstValueAt() != null;
    }

    @Override
    public Date getLastValueAt() {
        return Utils.createUnmutableTimestamp(this.lastValueAt);
    }

    @Override
    public void setLastValueAt(Date lastValueAt) {
        this.lastValueAt = Utils.createUnmutableTimestamp(lastValueAt);
    }

    @Override
    public boolean isSetLastValueAt() {
        return this.getLastValueAt() != null;
    }

    @Override
    public Data getFirstObservation() {
        return this.firstObservation;
    }

    @Override
    public void setFirstObservation(Data firstObservation) {
        this.firstObservation = firstObservation;
    }

    @Override
    public Data getLastObservation() {
        return this.lastObservation;
    }

    @Override
    public void setLastObservation(Data lastObservation) {
        this.lastObservation = lastObservation;
    }

    @Override
    public BigDecimal getFirstQuantityValue() {
        return this.firstQuantityValue;
    }

    @Override
    public void setFirstQuantityValue(BigDecimal firstValue) {
        this.firstQuantityValue = firstValue;
    }

    @Override
    public BigDecimal getLastQuantityValue() {
        return this.lastQuantityValue;
    }

    @Override
    public void setLastQuantityValue(BigDecimal lastValue) {
        this.lastQuantityValue = lastValue;
    }

    @Override
    public String getValueType() {
        return this.valueType == null || this.valueType.isEmpty() ? this.getDefaultDatasetType() : this.valueType;
    }

    @Override
    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    @Override
    public Set<Date> getResultTimes() {
        Set<Date> unmodifiableResultTimes = this.wrapToUnmutables(this.resultTimes);
        return unmodifiableResultTimes != null ? Collections.unmodifiableSet(unmodifiableResultTimes) : null;
    }

    @Override
    public void setResultTimes(Set<Date> resultTimes) {
        this.resultTimes = this.wrapToUnmutables(resultTimes);
    }

    private Set<Date> wrapToUnmutables(Set<Date> dates) {
        return dates != null ? dates.stream().map(d -> d != null ? new Timestamp(d.getTime()) : null).collect(Collectors.toSet()) : null;
    }

    @Override
    public UnitEntity getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(UnitEntity unit) {
        this.unit = unit;
    }

    @Override
    public boolean hasUnit() {
        return this.unit != null;
    }

    @Override
    public String getUnitI18nName(String locale) {
        return this.unit != null ? this.unit.getUnit() : "";
    }

    @Override
    public void setObservationCount(long count) {
        this.observationCount = count;
    }

    @Override
    public long getObservationCount() {
        return this.observationCount;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public DatasetEntity setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public FormatEntity getObservationType() {
        return this.observationType;
    }

    @Override
    public DatasetEntity setObservationType(FormatEntity observationType) {
        this.observationType = observationType;
        return this;
    }

    @Override
    public boolean isSetObservationtype() {
        return this.getObservationType() != null && this.getObservationType().isSetFormat();
    }

    @Override
    public boolean isMobile() {
        return this.mobile;
    }

    @Override
    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    @Override
    public boolean isInsitu() {
        return this.insitu;
    }

    @Override
    public void setInsitu(boolean insitu) {
        this.insitu = insitu;
    }

    @Override
    public String getOriginTimezone() {
        return this.originTimezone;
    }

    @Override
    public void setOriginTimezone(String originTimezone) {
        this.originTimezone = originTimezone;
    }

    @Override
    public Set<RelatedDatasetEntity> getRelatedDatasets() {
        return this.relatedDatasets;
    }

    @Override
    public void setRelatedObservations(Set<RelatedDatasetEntity> relatedDataset) {
        this.relatedDatasets.clear();
        if (relatedDataset != null) {
            this.relatedDatasets.addAll(relatedDataset);
        }
    }

    @Override
    public boolean hasRelatedDatasets() {
        return this.getRelatedDatasets() != null && !this.getRelatedDatasets().isEmpty();
    }

    @Override
    public String getLabelFrom(String locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.phenomenon.getLabelFrom(locale)).append(" ");
        sb.append(this.procedure.getLabelFrom(locale)).append(", ");
        sb.append(this.feature.getLabelFrom(locale)).append(", ");
        return sb.append(this.offering.getLabelFrom(locale)).toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" id: ").append(this.getId()).append(" , category: ").append(this.getCategory()).append(" , phenomenon: ").append(this.getPhenomenon()).append(" , procedure: ").append(this.getProcedure()).append(" , offering: ").append(this.getOffering()).append(" , feature: ").append(this.getFeature()).append(" , service: ").append(this.getService()).append(" ]").toString();
    }

    @Override
    public void copy(Dataset dataset) {
        this.setIdentifier(dataset.getIdentifier());
        this.setIdentifierCodespace(dataset.getIdentifierCodespace());
        this.setName(dataset.getName());
        this.setNameCodespace(dataset.getNameCodespace());
        this.setDescription(dataset.getDescription());
        if (dataset.getParameters() != null) {
            this.setParameters(dataset.getParameters().stream().collect(Collectors.toSet()));
        }
        this.setCategory(dataset.getCategory());
        this.setDeleted(dataset.isDeleted());
        this.setDeleted(dataset.isDeleted());
        this.setDisabled(dataset.isDisabled());
        this.setFeature(dataset.getFeature());
        this.setFirstObservation(dataset.getFirstObservation());
        this.setFirstQuantityValue(dataset.getFirstQuantityValue());
        this.setFirstValueAt(dataset.getFirstValueAt());
        this.setHidden(dataset.isHidden());
        this.setLastObservation(dataset.getLastObservation());
        this.setLastQuantityValue(dataset.getLastQuantityValue());
        this.setLastValueAt(dataset.getLastValueAt());
        this.setObservationCount(dataset.getObservationCount());
        this.setObservationType(dataset.getObservationType());
        this.setOffering(dataset.getOffering());
        this.setPhenomenon(dataset.getPhenomenon());
        this.setPlatform(dataset.getPlatform());
        this.setProcedure(dataset.getProcedure());
        this.setPublished(dataset.isPublished());
        if (dataset.getRelatedDatasets() != null) {
            this.setRelatedObservations(dataset.getRelatedDatasets().stream().collect(Collectors.toSet()));
        }
        if (dataset.getResultTimes() != null) {
            this.setResultTimes(dataset.getResultTimes().stream().collect(Collectors.toSet()));
        }
        this.setUnit(dataset.getUnit());
    }
}

