/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.IdentifierNameDescriptionEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.i18n.I18nEntity;
import org.n52.series.db.beans.parameter.Parameter;

public interface Describable
extends IdentifierNameDescriptionEntity,
HibernateRelations.HasId {
    public Set<I18nEntity<? extends Describable>> getTranslations();

    public void setTranslations(Set<I18nEntity<? extends Describable>> var1);

    public Set<Parameter<?>> getParameters();

    public void setParameters(Set<Parameter<?>> var1);

    default public boolean hasParameters() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    default public Set<Map<String, Object>> getMappedParameters(String locale) {
        return this.hasParameters() ? this.getParameters().stream().map(e -> e.toValueMap(locale)).collect(Collectors.toSet()) : null;
    }

    public ServiceEntity getService();

    public DescribableEntity setService(ServiceEntity var1);

    public String getNameI18n(String var1);

    default public String getLabelFrom(String locale) {
        if (this.isi18nNameAvailable(locale)) {
            return this.getNameI18n(locale);
        }
        if (this.isNameAvailable()) {
            return this.getName();
        }
        if (this.isDomainAvailable()) {
            return this.getDomain();
        }
        return Long.toString(this.getId());
    }

    default public boolean isNameAvailable() {
        return this.getName() != null && !this.getName().isEmpty();
    }

    default public boolean isDomainAvailable() {
        return this.getDomain() != null && !this.getDomain().isEmpty();
    }

    default public boolean isi18nNameAvailable(String locale) {
        return this.getNameI18n(locale) != null && !this.getNameI18n(locale).isEmpty();
    }

    default public boolean noTranslationAvailable(String locale) {
        return this.getTranslations() == null || locale == null || this.getTranslations().isEmpty() || locale.isEmpty();
    }

    default public String getCountryCode(String locale) {
        return locale.split("_")[0];
    }
}

