/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans.data;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.IdentifierNameDescriptionEntity;
import org.n52.series.db.beans.RelatedDataEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.beans.parameter.Parameter;

public interface Data<T>
extends HibernateRelations.HasId,
IdentifierNameDescriptionEntity,
HibernateRelations.HasPhenomenonTime,
HibernateRelations.HasDataset {
    public static final BigDecimal NOT_SET_VERTICAL = BigDecimal.valueOf(-99999.0);

    public T getValue();

    public void setValue(T var1);

    public boolean hasValue();

    public boolean isNoDataValue(Collection<String> var1);

    public GeometryEntity getGeometryEntity();

    public void setGeometryEntity(GeometryEntity var1);

    public boolean isSetGeometryEntity();

    public boolean getDeleted();

    public void setDeleted(boolean var1);

    public Date getValidTimeStart();

    public void setValidTimeStart(Date var1);

    public Date getValidTimeEnd();

    public void setValidTimeEnd(Date var1);

    public boolean isSetValidTime();

    public boolean isSetValidStartTime();

    public boolean isSetValidEndTime();

    public Date getResultTime();

    public void setResultTime(Date var1);

    public boolean isParent();

    public void setParent(boolean var1);

    public boolean isChild();

    public void setChild(boolean var1);

    public Set<RelatedDataEntity> getRelatedObservations();

    public void setRelatedObservations(Set<RelatedDataEntity> var1);

    default public boolean hasRelatedObservations() {
        return this.getRelatedObservations() != null && !this.getRelatedObservations().isEmpty();
    }

    public Set<Parameter<?>> getParameters();

    public void setParameters(Set<Parameter<?>> var1);

    default public boolean hasParameters() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    public String getValueIdentifier();

    public void setValueIdentifier(String var1);

    default public boolean hasValueIdentifier() {
        return this.getValueIdentifier() != null && !this.getValueIdentifier().isEmpty();
    }

    public String getValueName();

    public void setValueName(String var1);

    default public boolean hasValueName() {
        return this.getValueDescription() != null && !this.getValueName().isEmpty();
    }

    public String getValueDescription();

    public void setValueDescription(String var1);

    default public boolean hasValueDescription() {
        return this.getValueDescription() != null && !this.getValueDescription().isEmpty();
    }

    public BigDecimal getVerticalFrom();

    public void setVerticalFrom(BigDecimal var1);

    public BigDecimal getVerticalTo();

    public void setVerticalTo(BigDecimal var1);

    default public boolean hasVerticalFrom() {
        return this.getVerticalFrom() != null && !this.getVerticalFrom().equals(NOT_SET_VERTICAL);
    }

    default public boolean hasVerticalTo() {
        return this.getVerticalTo() != null && !this.getVerticalFrom().equals(NOT_SET_VERTICAL);
    }

    public static interface RecordData
    extends Data<Map<String, Object>> {
        public static final String DATASET_TYPE = "record";
    }

    public static interface TextData
    extends Data<String> {
        public static final String DATASET_TYPE = "text";
    }

    public static interface ReferencedData
    extends Data<String> {
        public static final String DATASET_TYPE = "referenced";
    }

    public static interface QuantityData
    extends Data<BigDecimal> {
        public static final String DATASET_TYPE = "quantity";
        public static final BigDecimal DOUBLE_THRESHOLD = BigDecimal.valueOf(1.0E-4);
    }

    public static interface ProfileData
    extends Data<Set<DataEntity<?>>> {
        public static final String DATASET_TYPE = "profile";

        public String getVerticalFromName();

        public void setVerticalFromName(String var1);

        public String getVerticalToName();

        public void setVerticalToName(String var1);

        public UnitEntity getVerticalUnit();

        public void setVerticalUnit(UnitEntity var1);

        default public boolean hasVerticalUnit() {
            return this.getVerticalUnit() != null && this.getVerticalUnit().isSetIdentifier();
        }

        default public boolean hasVerticalFromName() {
            return this.getVerticalFromName() != null && !this.getVerticalFromName().isEmpty();
        }

        default public boolean hasVerticalToName() {
            return this.getVerticalToName() != null && !this.getVerticalToName().isEmpty();
        }
    }

    public static interface GeometryData
    extends Data<GeometryEntity> {
        public static final String DATASET_TYPE = "geoemtry";
    }

    public static interface DataArrayData
    extends Data<Set<DataEntity<?>>> {
        public static final String DATASET_TYPE = "dataarray";
    }

    public static interface CountData
    extends Data<Integer> {
        public static final String DATASET_TYPE = "count";
    }

    public static interface ComplexData
    extends Data<Set<DataEntity<?>>> {
        public static final String DATASET_TYPE = "complex";
    }

    public static interface CategoryData
    extends Data<String> {
        public static final String DATASET_TYPE = "category";
    }

    public static interface BooleanData
    extends Data<Boolean> {
        public static final String DATASET_TYPE = "boolean";
    }

    public static interface BlobData
    extends Data<Object> {
        public static final String DATASET_TYPE = "blob";
    }
}

