/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans.ereporting;

import java.util.ArrayList;
import java.util.Collection;
import org.n52.series.db.beans.data.Data;
import org.n52.series.db.beans.ereporting.EReportingDataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EReportingCountDataEntity
extends EReportingDataEntity<Integer>
implements Data.CountData {
    private static final Logger LOGGER = LoggerFactory.getLogger(EReportingCountDataEntity.class);
    private static final long serialVersionUID = 1753251418906573384L;

    @Override
    public boolean isNoDataValue(Collection<String> noDataValues) {
        Integer value = (Integer)this.getValue();
        return value == null || this.containsValue(noDataValues, value);
    }

    private boolean containsValue(Collection<String> collection, Integer value) {
        for (Integer noDataValue : this.convertToIntegers(collection)) {
            if (!noDataValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    private Collection<Integer> convertToIntegers(Collection<String> collection) {
        ArrayList<Integer> validatedValues = new ArrayList<Integer>();
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                validatedValues.add(Integer.parseInt(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Ignoring NO_DATA value {} (not an integer).", (Object)trimmed);
            }
        }
        return validatedValues;
    }

    @Override
    public boolean isSetValue() {
        return this.getValue() != null;
    }

    @Override
    public String getValueAsString() {
        return this.isSetValue() ? ((Integer)this.getValue()).toString() : "";
    }
}

