/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans.ereporting;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.n52.series.db.beans.data.Data;
import org.n52.series.db.beans.ereporting.EReportingDataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EReportingQuantityDataEntity
extends EReportingDataEntity<BigDecimal>
implements Data.QuantityData {
    private static final long serialVersionUID = 5870100531719269673L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EReportingQuantityDataEntity.class);

    @Override
    public boolean isNoDataValue(Collection<String> noDataValues) {
        BigDecimal value = (BigDecimal)this.getValue();
        return value == null || this.containsValue(noDataValues, value);
    }

    private boolean containsValue(Collection<String> collection, BigDecimal key) {
        if (collection == null) {
            return false;
        }
        for (BigDecimal noDataValue : this.convertToDoubles(collection)) {
            if (noDataValue.subtract(key).abs().compareTo(DOUBLE_THRESHOLD) >= 0) continue;
            return true;
        }
        return false;
    }

    private Collection<BigDecimal> convertToDoubles(Collection<String> collection) {
        ArrayList<BigDecimal> validatedValues = new ArrayList<BigDecimal>();
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                validatedValues.add(new BigDecimal(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Ignoring NO_DATA value {} (not a big decimal value).", (Object)trimmed);
            }
        }
        return validatedValues;
    }

    @Override
    public boolean isSetValue() {
        return this.getValue() != null;
    }

    @Override
    public String getValueAsString() {
        return this.isSetValue() ? ((BigDecimal)this.getValue()).toString() : "";
    }
}

