/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FormatEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.RelatedDatasetEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.beans.VerticalMetadataEntity;
import org.n52.series.db.beans.dataset.DatasetType;
import org.n52.series.db.beans.dataset.ObservationType;
import org.n52.series.db.beans.dataset.ValueType;
import org.n52.series.db.beans.ereporting.EReportingProfileDatasetEntity;
import org.n52.series.db.beans.sampling.SamplingProfileDatasetEntity;
import org.n52.series.db.common.Utils;

public class DatasetEntity
extends DescribableEntity
implements Serializable {
    public static final String ENTITY_ALIAS = "dataset";
    public static final String PROPERTY_OFFERING = "offering";
    public static final String PROPERTY_PROCEDURE = "procedure";
    public static final String PROPERTY_PLATFORM = "platform";
    public static final String PROPERTY_PHENOMENON = "phenomenon";
    public static final String PROPERTY_CATEGORY = "category";
    public static final String PROPERTY_FEATURE = "feature";
    public static final String PROPERTY_DATASET_TYPE = "datasetType";
    public static final String PROPERTY_OBSERVATION_TYPE = "observationType";
    public static final String PROPERTY_VALUE_TYPE = "valueType";
    public static final String PROPERTY_FIRST_VALUE_AT = "firstValueAt";
    public static final String PROPERTY_LAST_VALUE_AT = "lastValueAt";
    public static final String PROPERTY_PUBLISHED = "published";
    public static final String PROPERTY_DELETED = "deleted";
    public static final String HIDDEN_CHILD = "hidden";
    public static final String PROPERTY_MOBILE = "mobile";
    public static final String PROPERTY_INSITU = "insitu";
    public static final String PROPERTY_UNIT = "unit";
    public static final String PROPERTY_SAMPLING_PROFILE = "samplingProfile";
    public static final String PROPERTY_EREPORTING_PROFILE = "ereportingProfile";
    private static final long serialVersionUID = -7491530543976690237L;
    private PhenomenonEntity phenomenon;
    private ProcedureEntity procedure;
    private OfferingEntity offering;
    private AbstractFeatureEntity<?> feature;
    private CategoryEntity category;
    private PlatformEntity platform;
    private boolean published = true;
    private boolean deleted;
    private boolean disabled;
    private DatasetType datasetType;
    private ObservationType observationType;
    private ValueType valueType;
    private Set<Date> resultTimes;
    private Date firstValueAt;
    private Date lastValueAt;
    private DataEntity<?> firstObservation;
    private DataEntity<?> lastObservation;
    private BigDecimal firstQuantityValue;
    private BigDecimal lastQuantityValue;
    private UnitEntity unit;
    private long observationCount = -1L;
    private boolean hidden;
    private FormatEntity omObservationType;
    private boolean mobile;
    private boolean insitu = true;
    private String originTimezone;
    private final Set<RelatedDatasetEntity> relatedDatasets = new LinkedHashSet<RelatedDatasetEntity>();
    private List<DatasetEntity> referenceValues = new ArrayList<DatasetEntity>();
    private Integer numberOfDecimals;
    private VerticalMetadataEntity verticalMetadata;
    private SamplingProfileDatasetEntity samplingProfile;
    private EReportingProfileDatasetEntity ereportingProfile;

    public DatasetEntity() {
        this(ValueType.not_initialized);
    }

    public DatasetEntity(String type) {
        this(ValueType.valueOf(type));
    }

    public DatasetEntity(ValueType type) {
        this.valueType = type;
    }

    public CategoryEntity getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEntity category) {
        this.category = category;
    }

    public PhenomenonEntity getPhenomenon() {
        return this.phenomenon;
    }

    public DatasetEntity setPhenomenon(PhenomenonEntity phenomenon) {
        this.phenomenon = phenomenon;
        return this;
    }

    public PhenomenonEntity getObservableProperty() {
        return this.getPhenomenon();
    }

    public DatasetEntity setObservableProperty(PhenomenonEntity observableProperty) {
        return this.setPhenomenon(observableProperty);
    }

    public ProcedureEntity getProcedure() {
        return this.procedure;
    }

    public DatasetEntity setProcedure(ProcedureEntity procedure) {
        this.procedure = procedure;
        return this;
    }

    public OfferingEntity getOffering() {
        return this.offering;
    }

    public DatasetEntity setOffering(OfferingEntity offering) {
        this.offering = offering;
        return this;
    }

    public boolean isSetOffering() {
        return this.getOffering() != null;
    }

    public AbstractFeatureEntity<?> getFeature() {
        return this.feature;
    }

    public void setFeature(AbstractFeatureEntity<?> feature) {
        this.feature = feature;
    }

    public boolean isSetFeature() {
        return this.getFeature() != null;
    }

    public PlatformEntity getPlatform() {
        return this.platform;
    }

    public void setPlatform(PlatformEntity platform) {
        this.platform = platform;
    }

    public Boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public DatasetEntity setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public DatasetEntity setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isSetOmObservationType() {
        return this.getOmObservationType() != null && this.getOmObservationType().isSetFormat();
    }

    public Date getFirstValueAt() {
        return Utils.createUnmutableTimestamp(this.firstValueAt);
    }

    public void setFirstValueAt(Date firstValueAt) {
        this.firstValueAt = Utils.createUnmutableTimestamp(firstValueAt);
    }

    public boolean isSetFirstValueAt() {
        return this.getFirstValueAt() != null;
    }

    public Date getLastValueAt() {
        return Utils.createUnmutableTimestamp(this.lastValueAt);
    }

    public void setLastValueAt(Date lastValueAt) {
        this.lastValueAt = Utils.createUnmutableTimestamp(lastValueAt);
    }

    public boolean isSetLastValueAt() {
        return this.getLastValueAt() != null;
    }

    public DataEntity<?> getFirstObservation() {
        return this.firstObservation;
    }

    public void setFirstObservation(DataEntity<?> firstObservation) {
        this.firstObservation = firstObservation;
    }

    public DataEntity<?> getLastObservation() {
        return this.lastObservation;
    }

    public void setLastObservation(DataEntity<?> lastObservation) {
        this.lastObservation = lastObservation;
    }

    public BigDecimal getFirstQuantityValue() {
        return this.firstQuantityValue;
    }

    public void setFirstQuantityValue(BigDecimal firstValue) {
        this.firstQuantityValue = firstValue;
    }

    public BigDecimal getLastQuantityValue() {
        return this.lastQuantityValue;
    }

    public void setLastQuantityValue(BigDecimal lastValue) {
        this.lastQuantityValue = lastValue;
    }

    public DatasetType getDatasetType() {
        return this.datasetType;
    }

    public void setDatasetType(DatasetType datasetType) {
        this.datasetType = datasetType;
    }

    public ObservationType getObservationType() {
        return this.observationType;
    }

    public void setObservationType(ObservationType observationType) {
        this.observationType = observationType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public Set<Date> getResultTimes() {
        Set<Date> unmodifiableResultTimes = this.wrapToUnmutables(this.resultTimes);
        return unmodifiableResultTimes != null ? Collections.unmodifiableSet(unmodifiableResultTimes) : null;
    }

    public void setResultTimes(Set<Date> resultTimes) {
        this.resultTimes = this.wrapToUnmutables(resultTimes);
    }

    private Set<Date> wrapToUnmutables(Set<Date> dates) {
        return dates != null ? dates.stream().map(d -> d != null ? new Timestamp(d.getTime()) : null).collect(Collectors.toSet()) : null;
    }

    public UnitEntity getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEntity unit) {
        this.unit = unit;
    }

    public boolean hasUnit() {
        return this.unit != null;
    }

    public String getUnitI18nName(String locale) {
        return this.unit != null ? this.unit.getUnit() : "";
    }

    public List<DatasetEntity> getReferenceValues() {
        return this.referenceValues;
    }

    public DatasetEntity setReferenceValues(Collection<DatasetEntity> referenceValues) {
        this.referenceValues.clear();
        if (referenceValues != null) {
            this.referenceValues.addAll(referenceValues);
        }
        return this;
    }

    public boolean hasReferenceValues() {
        return this.getReferenceValues() != null && !this.getReferenceValues().isEmpty();
    }

    public Integer getNumberOfDecimals() {
        return this.numberOfDecimals;
    }

    public DatasetEntity setNumberOfDecimals(Integer numberOfDecimals) {
        this.numberOfDecimals = numberOfDecimals;
        return this;
    }

    public void setObservationCount(long count) {
        this.observationCount = count;
    }

    public long getObservationCount() {
        return this.observationCount;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public DatasetEntity setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public FormatEntity getOmObservationType() {
        return this.omObservationType;
    }

    public DatasetEntity setOmObservationType(FormatEntity omObservationType) {
        this.omObservationType = omObservationType;
        return this;
    }

    public boolean isSetOmObservationtype() {
        return this.getOmObservationType() != null && this.getOmObservationType().isSetFormat();
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    public boolean isInsitu() {
        return this.insitu;
    }

    public void setInsitu(boolean insitu) {
        this.insitu = insitu;
    }

    public String getOriginTimezone() {
        return this.originTimezone;
    }

    public void setOriginTimezone(String originTimezone) {
        this.originTimezone = originTimezone;
    }

    public boolean isSetOriginTimezone() {
        return this.getOriginTimezone() != null && !this.getOriginTimezone().isEmpty();
    }

    public Set<RelatedDatasetEntity> getRelatedDatasets() {
        return this.relatedDatasets;
    }

    public void setRelatedObservations(Set<RelatedDatasetEntity> relatedDataset) {
        this.relatedDatasets.clear();
        if (relatedDataset != null) {
            this.relatedDatasets.addAll(relatedDataset);
        }
    }

    public boolean hasRelatedDatasets() {
        return this.getRelatedDatasets() != null && !this.getRelatedDatasets().isEmpty();
    }

    public VerticalMetadataEntity getVerticalMetadata() {
        return this.verticalMetadata;
    }

    public void setVerticalMetadata(VerticalMetadataEntity verticalMetadata) {
        this.verticalMetadata = verticalMetadata;
    }

    public boolean hasVerticalMetadata() {
        return this.getVerticalMetadata() != null;
    }

    public SamplingProfileDatasetEntity getSamplingProfile() {
        return this.samplingProfile;
    }

    public void setSamplingProfile(SamplingProfileDatasetEntity samplingProfile) {
        this.samplingProfile = samplingProfile;
    }

    public boolean hasSamplingProfile() {
        return this.getSamplingProfile() != null;
    }

    public EReportingProfileDatasetEntity getEreportingProfile() {
        return this.ereportingProfile;
    }

    public void setEreportingProfile(EReportingProfileDatasetEntity ereportingProfile) {
        this.ereportingProfile = ereportingProfile;
    }

    public boolean hasEreportingProfile() {
        return this.getEreportingProfile() != null;
    }

    @Override
    public String getLabelFrom(String locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.phenomenon.getLabelFrom(locale)).append(" ");
        sb.append(this.procedure.getLabelFrom(locale)).append(", ");
        sb.append(this.feature.getLabelFrom(locale)).append(", ");
        return sb.append(this.offering.getLabelFrom(locale)).toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" id: ").append(this.getId()).append(" , category: ").append(this.getCategory()).append(" , phenomenon: ").append(this.getPhenomenon()).append(" , procedure: ").append(this.getProcedure()).append(" , offering: ").append(this.getOffering()).append(" , feature: ").append(this.getFeature()).append(" , service: ").append(this.getService()).append(" ]").toString();
    }

    public void copy(DatasetEntity dataset) {
        this.setIdentifier(dataset.getIdentifier());
        this.setIdentifierCodespace(dataset.getIdentifierCodespace());
        this.setName(dataset.getName());
        this.setNameCodespace(dataset.getNameCodespace());
        this.setDescription(dataset.getDescription());
        if (dataset.getParameters() != null) {
            this.setParameters(dataset.getParameters().stream().collect(Collectors.toSet()));
        }
        this.setCategory(dataset.getCategory());
        this.setDeleted(dataset.isDeleted());
        this.setDeleted(dataset.isDeleted());
        this.setDisabled(dataset.isDisabled());
        this.setFeature(dataset.getFeature());
        this.setFirstObservation(dataset.getFirstObservation());
        this.setFirstQuantityValue(dataset.getFirstQuantityValue());
        this.setFirstValueAt(dataset.getFirstValueAt());
        this.setHidden(dataset.isHidden());
        this.setLastObservation(dataset.getLastObservation());
        this.setLastQuantityValue(dataset.getLastQuantityValue());
        this.setLastValueAt(dataset.getLastValueAt());
        this.setObservationCount(dataset.getObservationCount());
        this.setOmObservationType(dataset.getOmObservationType());
        this.setOffering(dataset.getOffering());
        this.setPhenomenon(dataset.getPhenomenon());
        this.setPlatform(dataset.getPlatform());
        this.setProcedure(dataset.getProcedure());
        this.setPublished(dataset.isPublished());
        if (dataset.getRelatedDatasets() != null) {
            this.setRelatedObservations(dataset.getRelatedDatasets().stream().collect(Collectors.toSet()));
        }
        if (dataset.getResultTimes() != null) {
            this.setResultTimes(dataset.getResultTimes().stream().collect(Collectors.toSet()));
        }
        if (dataset.hasSamplingProfile()) {
            this.setSamplingProfile(new SamplingProfileDatasetEntity().copy(dataset.getSamplingProfile()));
        }
        if (dataset.hasEreportingProfile()) {
            this.setEreportingProfile(new EReportingProfileDatasetEntity().copy(dataset.getEreportingProfile()));
        }
        this.setUnit(dataset.getUnit());
    }
}

