/*
 * Copyright 2015-2019 52°North Initiative for Geospatial Open Source
 * Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.series.db.beans.ereporting;

import org.locationtech.jts.geom.Geometry;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.HibernateRelations.HasGeometry;

/**
 * Entity for AQD e-Reporting Station
 *
 * @author <a href="mailto:c.hollmann@52north.org">Carsten Hollmann</a>
 * @since 1.0.0
 */
public class EReportingStationEntity extends DescribableEntity implements HasGeometry<EReportingStationEntity> {

    private static final long serialVersionUID = 743675189477493870L;

    private Long station;

    private GeometryEntity geometryEntity;

    /**
     * @return the station
     */
    public Long getStation() {
        return station;
    }

    /**
     * @param station
     *            the station to set
     * @return this
     */
    public EReportingStationEntity setStation(Long station) {
        this.station = station;
        return this;
    }

    @Override
    public GeometryEntity getGeometryEntity() {
        return geometryEntity;
    }

    public EReportingStationEntity setGeometry(Geometry geometry) {
        this.geometryEntity = new GeometryEntity();
        this.geometryEntity.setGeometry(geometry);
        this.geometryEntity.setSrid(geometry.getSRID());
        return this;
    }

    @Override
    public EReportingStationEntity setGeometryEntity(GeometryEntity geometryEntity) {
        this.geometryEntity = geometryEntity;
        return this;
    }
}
