/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.IdEntity;
import org.n52.series.db.beans.RelatedDataEntity;
import org.n52.series.db.beans.ereporting.EReportingProfileDataEntity;
import org.n52.series.db.beans.sampling.SamplingProfileDataEntity;
import org.n52.series.db.common.Utils;

public abstract class DataEntity<T>
extends DescribableEntity
implements Comparable<DataEntity<T>>,
Serializable {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_RESULT_TIME = "resultTime";
    public static final String PROPERTY_SAMPLING_TIME_START = "samplingTimeStart";
    public static final String PROPERTY_SAMPLING_TIME_END = "samplingTimeEnd";
    public static final String PROPERTY_VALID_TIME_START = "valid_time_start";
    public static final String PROPERTY_VALID_TIME_END = "valid_time_end";
    public static final String PROPERTY_GEOMETRY_ENTITY = "geometryEntity";
    public static final String PROPERTY_DELETED = "deleted";
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_IDENTIFIER = "identifier";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_SAMPLING_PROFILE = "samplingProfile";
    public static final String PROPERTY_EREPORTING_PROFILE = "ereportingProfile";
    public static final BigDecimal NOT_SET_VERTICAL = BigDecimal.valueOf(-99999.0);
    private static final long serialVersionUID = 273612846605300612L;
    private Date samplingTimeStart;
    private Date samplingTimeEnd;
    private T value;
    private GeometryEntity geometryEntity;
    private boolean deleted;
    private Date validTimeStart;
    private Date validTimeEnd;
    private Date resultTime;
    private Long parent;
    private DatasetEntity dataset;
    private Set<RelatedDataEntity> relatedObservations = new HashSet<RelatedDataEntity>(0);
    private String valueIdentifier;
    private String valueName;
    private String valueDescription;
    private BigDecimal verticalFrom = NOT_SET_VERTICAL;
    private BigDecimal verticalTo = NOT_SET_VERTICAL;
    private SamplingProfileDataEntity samplingProfile;
    private EReportingProfileDataEntity ereportingProfile;

    protected DataEntity() {
    }

    public Date getSamplingTimeStart() {
        return Utils.createUnmutableTimestamp(this.samplingTimeStart);
    }

    public void setSamplingTimeStart(Date samplingTimeStart) {
        this.samplingTimeStart = Utils.createUnmutableTimestamp(samplingTimeStart);
    }

    public Date getSamplingTimeEnd() {
        return Utils.createUnmutableTimestamp(this.samplingTimeEnd);
    }

    public void setSamplingTimeEnd(Date samplingTimeEnd) {
        this.samplingTimeEnd = Utils.createUnmutableTimestamp(samplingTimeEnd);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    public abstract boolean isNoDataValue(Collection<String> var1);

    public GeometryEntity getGeometryEntity() {
        return this.geometryEntity;
    }

    public void setGeometryEntity(GeometryEntity geometryEntity) {
        this.geometryEntity = geometryEntity;
    }

    public boolean isSetGeometryEntity() {
        return this.geometryEntity != null && !this.geometryEntity.isEmpty();
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Date getValidTimeStart() {
        return Utils.createUnmutableTimestamp(this.validTimeStart);
    }

    public void setValidTimeStart(Date validTimeStart) {
        this.validTimeStart = Utils.createUnmutableTimestamp(validTimeStart);
    }

    public Date getValidTimeEnd() {
        return Utils.createUnmutableTimestamp(this.validTimeEnd);
    }

    public void setValidTimeEnd(Date validTimeEnd) {
        this.validTimeEnd = Utils.createUnmutableTimestamp(validTimeEnd);
    }

    public boolean isSetValidTime() {
        return this.isSetValidStartTime() && this.isSetValidEndTime();
    }

    public boolean isSetValidStartTime() {
        return this.validTimeStart != null;
    }

    public boolean isSetValidEndTime() {
        return this.validTimeEnd != null;
    }

    public Date getResultTime() {
        return Utils.createUnmutableTimestamp(this.resultTime);
    }

    public void setResultTime(Date resultTime) {
        this.resultTime = Utils.createUnmutableTimestamp(resultTime);
    }

    public Long getParent() {
        return this.parent;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public DatasetEntity getDataset() {
        return this.dataset;
    }

    public void setDataset(DatasetEntity dataset) {
        this.dataset = dataset;
    }

    public Set<RelatedDataEntity> getRelatedObservations() {
        return this.relatedObservations;
    }

    public void setRelatedObservations(Set<RelatedDataEntity> relatedObservations) {
        this.relatedObservations = relatedObservations;
    }

    public boolean hasRelatedObservations() {
        return this.getRelatedObservations() != null && !this.getRelatedObservations().isEmpty();
    }

    public String getValueIdentifier() {
        return this.valueIdentifier;
    }

    public void setValueIdentifier(String valueIdentifier) {
        this.valueIdentifier = valueIdentifier;
    }

    public boolean hasValueIdentifier() {
        return this.getValueIdentifier() != null && !this.getValueIdentifier().isEmpty();
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public boolean hasValueName() {
        return this.getValueName() != null && !this.getValueName().isEmpty();
    }

    public String getValueDescription() {
        return this.valueDescription;
    }

    public void setValueDescription(String valueDescription) {
        this.valueDescription = valueDescription;
    }

    public boolean hasValueDescription() {
        return this.getValueDescription() != null && !this.getValueDescription().isEmpty();
    }

    public BigDecimal getVerticalFrom() {
        return this.verticalFrom;
    }

    public void setVerticalFrom(BigDecimal verticalFrom) {
        this.verticalFrom = verticalFrom;
    }

    public boolean hasVerticalFrom() {
        return this.getVerticalFrom() != null && this.getVerticalFrom().compareTo(NOT_SET_VERTICAL) != 0;
    }

    public BigDecimal getVerticalTo() {
        return this.verticalTo;
    }

    public void setVerticalTo(BigDecimal verticalTo) {
        this.verticalTo = verticalTo;
    }

    public boolean hasVerticalTo() {
        return this.getVerticalTo() != null && this.getVerticalTo().compareTo(NOT_SET_VERTICAL) != 0;
    }

    public SamplingProfileDataEntity getSamplingProfile() {
        return this.samplingProfile;
    }

    public void setSamplingProfile(SamplingProfileDataEntity samplingProfile) {
        this.samplingProfile = samplingProfile;
    }

    public boolean hasSamplingProfile() {
        return this.getSamplingProfile() != null;
    }

    public EReportingProfileDataEntity getEreportingProfile() {
        return this.ereportingProfile;
    }

    public void setEreportingProfile(EReportingProfileDataEntity ereportingProfile) {
        this.ereportingProfile = ereportingProfile;
    }

    public boolean hasEreportingProfile() {
        return this.getEreportingProfile() != null;
    }

    @Override
    public int compareTo(DataEntity<T> o) {
        return Comparator.comparing(DataEntity::getSamplingTimeEnd).thenComparing(DataEntity::getSamplingTimeStart).thenComparing(IdEntity::getId).compare(this, o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataEntity other = (DataEntity)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" id: ").append(this.getId()).append(" ]").toString();
    }
}

