/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.IdentifierNameDescriptionEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.i18n.I18nEntity;
import org.n52.series.db.beans.parameter.ParameterEntity;

public interface Describable
extends IdentifierNameDescriptionEntity,
HibernateRelations.HasId {
    public static final String LOCALE_REGEX = "[-_# ]";

    public ServiceEntity getService();

    public DescribableEntity setService(ServiceEntity var1);

    public Set<I18nEntity<? extends Describable>> getTranslations();

    public void setTranslations(Set<I18nEntity<? extends Describable>> var1);

    public Set<ParameterEntity<?>> getParameters();

    public void setParameters(Set<ParameterEntity<?>> var1);

    default public boolean hasParameters() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    default public Set<Map<String, Object>> getMappedParameters(String locale) {
        return this.hasParameters() ? this.getParameters().stream().map(e -> e.toValueMap(locale)).collect(Collectors.toSet()) : null;
    }

    default public String getLabelFrom(String locale) {
        if (this.isi18nNameAvailable(locale)) {
            return this.getNameI18n(locale);
        }
        if (this.isNameAvailable()) {
            return this.getName();
        }
        if (this.isDomainAvailable()) {
            return this.getDomain();
        }
        return Long.toString(this.getId());
    }

    default public boolean isNameAvailable() {
        return this.getName() != null && !this.getName().isEmpty();
    }

    default public boolean isDomainAvailable() {
        return this.getDomain() != null && !this.getDomain().isEmpty();
    }

    default public boolean isi18nNameAvailable(String locale) {
        return this.getNameI18n(locale) != null && !this.getNameI18n(locale).isEmpty();
    }

    default public boolean noTranslationAvailable(String locale) {
        return this.getTranslations() == null || locale == null || this.getTranslations().isEmpty() || locale.isEmpty();
    }

    default public String getNameI18n(String locale) {
        if (this.noTranslationAvailable(locale)) {
            return this.getName();
        }
        I18nEntity<? extends Describable> translation = this.getTranslation(locale);
        return translation != null ? translation.getName() : this.getName();
    }

    default public String getDescriptionI18n(String locale) {
        if (this.noTranslationAvailable(locale)) {
            return this.getDescription();
        }
        I18nEntity<? extends Describable> translation = this.getTranslation(locale);
        return translation != null ? translation.getDescription() : this.getDescription();
    }

    default public String getCountryCode(String locale) {
        if (locale != null) {
            return locale.split(LOCALE_REGEX).length > 1 ? locale.split(LOCALE_REGEX)[1] : locale.split(LOCALE_REGEX)[0];
        }
        return "";
    }

    default public I18nEntity<? extends Describable> getTranslation(String locale) {
        if (!this.noTranslationAvailable(locale)) {
            String countryCode = this.getCountryCode(locale);
            Locale matchingLocale = this.getMatchingLocale(this.getTranslations(), locale);
            for (I18nEntity<? extends Describable> translation : this.getTranslations()) {
                Locale translatedLocale = LocaleHelper.decode((String)translation.getLocale());
                if (!translatedLocale.equals(matchingLocale) && !translatedLocale.getCountry().equalsIgnoreCase(countryCode)) continue;
                return translation;
            }
        }
        return null;
    }

    default public Locale getMatchingLocale(Set<I18nEntity<? extends Describable>> translations, String queriedLocale) {
        List<Locale.LanguageRange> localeRange = Locale.LanguageRange.parse(queriedLocale);
        return Locale.lookup(localeRange, translations.stream().map(t -> LocaleHelper.decode((String)t.getLocale())).collect(Collectors.toSet()));
    }
}

