/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEntity
extends DescribableEntity {
    private static final long serialVersionUID = 8926184900932191238L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceEntity.class);
    private String url;
    private String type = "RESTful series data access layer.";
    private List<String> noDataValues = Collections.emptyList();
    private String version;
    private boolean supportsFirstLatest = true;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNoDataValue(DataEntity<?> observation) {
        return observation.isNoDataValue(this.noDataValues);
    }

    public String getNoDataValues() {
        String csv = Arrays.toString((Object[])this.noDataValues.toArray(new Double[0]));
        return csv.substring(1).substring(0, csv.length() - 2);
    }

    public void setNoDataValues(String noDataValues) {
        LOGGER.debug("Set noData values: {}", (Object)noDataValues);
        if (noDataValues == null || noDataValues.isEmpty()) {
            this.noDataValues = Collections.emptyList();
        } else {
            String[] values = noDataValues.split(",");
            this.noDataValues = Arrays.asList(values);
        }
    }

    public boolean isSupportsFirstLatest() {
        return this.supportsFirstLatest;
    }

    public void setSupportsFirstLatest(boolean supportsFirstLatest) {
        this.supportsFirstLatest = supportsFirstLatest;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" url: ").append(this.getUrl()).append(", type: ").append(this.getType()).append(", version: ").append(this.getVersion()).append(", noDataValues: ").append(this.getNoDataValues()).append(" ]").toString();
    }
}

