/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.math.BigDecimal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.TextDataEntity;

public class ServiceEntityTest {
    private ServiceEntity serviceInfo;

    @Before
    public void setUp() {
        this.serviceInfo = new ServiceEntity();
    }

    public void shouldNotFailWhenSettingInvalidNoDataValues() {
        TextDataEntity entity = new TextDataEntity();
        this.serviceInfo.setNoDataValues("4.3,9,no-data");
        entity.setValue((Object)"no-data");
        MatcherAssert.assertThat((Object)this.serviceInfo.isNoDataValue((DataEntity)entity), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldTreatNullAsNoDataValue() {
        QuantityDataEntity entity = new QuantityDataEntity();
        entity.setValue(null);
        MatcherAssert.assertThat((Object)this.serviceInfo.isNoDataValue((DataEntity)entity), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldTreatNaNAsNoDataValue() {
        QuantityDataEntity entity = new QuantityDataEntity();
        MatcherAssert.assertThat((Object)this.serviceInfo.isNoDataValue((DataEntity)entity), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHandleDoubleValues() {
        this.serviceInfo.setNoDataValues("4.3,9,foo");
        QuantityDataEntity entity = new QuantityDataEntity();
        entity.setValue((Object)BigDecimal.valueOf(9.0));
        MatcherAssert.assertThat((Object)this.serviceInfo.isNoDataValue((DataEntity)entity), (Matcher)Is.is((Object)true));
        entity.setValue((Object)BigDecimal.valueOf(4.3));
        MatcherAssert.assertThat((Object)this.serviceInfo.isNoDataValue((DataEntity)entity), (Matcher)Is.is((Object)true));
    }
}

