/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans.dataset;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public enum DatasetType {
    individualObservation,
    timeseries,
    profile,
    trajectory,
    not_initialized;

    public static final String ALL = "all";

    public static Set<DatasetType> convert(Set<String> values) {
        if (values != null) {
            return values.stream().map(at -> DatasetType.getIgnoreCase(at)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return null;
    }

    private static DatasetType getIgnoreCase(String value) {
        for (DatasetType dt : DatasetType.values()) {
            if (!dt.name().equalsIgnoreCase(value)) continue;
            return dt;
        }
        return null;
    }
}

