/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans.dataset;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public enum ValueType {
    quantity,
    count,
    text,
    category,
    bool,
    geometry,
    blob,
    referenced,
    complex,
    dataarray,
    not_initialized;

    public static final String ALL = "all";

    public static Set<ValueType> convert(Collection<String> values) {
        if (values != null) {
            return values.stream().map(at -> ValueType.getIgnoreCase(at)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return null;
    }

    private static ValueType getIgnoreCase(String value) {
        for (ValueType dt : ValueType.values()) {
            if (!dt.name().equalsIgnoreCase(value)) continue;
            return dt;
        }
        return null;
    }
}

