/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.hibernate.boot.MetadataSources;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.n52.hibernate.spatial.dialect.TimestampWithTimeZoneGeoDBDialectNoComments;
import org.n52.hibernate.spatial.dialect.TimestampWithTimeZonePostgisPG95DialectNoComments;
import org.n52.hibernate.spatial.dialect.TimestampWithTimeZoneSqlServer2008SpatialDialectNoComments;
import org.n52.hibernate.spatial.dialect.h2geodb.TimestampWithTimeZoneGeoDBDialect;
import org.n52.hibernate.spatial.dialect.postgis.TimestampWithTimeZonePostgisPG95Dialect;
import org.n52.hibernate.spatial.dialect.sqlserver.TimestampWithTimeZoneSqlServer2008SpatialDialect;

public abstract class AbstractGenerator {
    protected Dialect getDialect(DialectSelector selection, boolean comments) throws Exception {
        switch (selection) {
            case POSTGIS: {
                return comments ? new TimestampWithTimeZonePostgisPG95Dialect() : new TimestampWithTimeZonePostgisPG95DialectNoComments();
            }
            case ORACLE: 
            case GEODB: {
                return comments ? new TimestampWithTimeZoneGeoDBDialect() : new TimestampWithTimeZoneGeoDBDialectNoComments();
            }
            case MY_SQL_SPATIAL_5: {
                return comments ? new TimestampWithTimeZoneSqlServer2008SpatialDialect() : new TimestampWithTimeZoneSqlServer2008SpatialDialectNoComments();
            }
            case SQL_SERVER_2008: {
                return comments ? new TimestampWithTimeZoneSqlServer2008SpatialDialect() : new TimestampWithTimeZoneSqlServer2008SpatialDialectNoComments();
            }
        }
        throw new Exception("The entered value is invalid: " + (Object)((Object)selection));
    }

    protected void setDirectoriesForModelSelection(Concept concept, Profile profile, Configuration configuration, MetadataSources metadataSources) throws Exception {
        LinkedList files = new LinkedList();
        for (File file : files) {
            if (configuration != null) {
                configuration.addDirectory(file);
            }
            if (metadataSources == null) continue;
            metadataSources.addDirectory(file);
        }
        this.addConceptDirectories(concept, profile, configuration, metadataSources);
    }

    protected void addConceptDirectories(Concept concept, Profile profile, Configuration configuration, MetadataSources metadataSources) throws Exception {
        LinkedList<String> paths = new LinkedList<String>();
        switch (concept) {
            case SIMPLE: {
                paths.addAll(this.getProfileDirectories("/hbm/simple", profile));
                break;
            }
            case E_REPORTING: {
                paths.addAll(this.getProfileDirectories("/hbm/ereporting", Profile.DEFAULT));
                break;
            }
            case TRANSACTIONAL: {
                paths.addAll(this.getProfileDirectories("/hbm/transactional", profile));
                break;
            }
            case PROXY: {
                paths.addAll(this.getProfileDirectories("/hbm/proxy", profile));
                break;
            }
            default: {
                throw new Exception("The entered value is invalid: " + (Object)((Object)concept));
            }
        }
        for (String path : paths) {
            if (configuration != null) {
                configuration.addDirectory(AbstractGenerator.getDirectory(path));
            }
            if (metadataSources == null) continue;
            metadataSources.addDirectory(AbstractGenerator.getDirectory(path));
        }
    }

    protected Collection<String> getProfileDirectories(String p, Profile profile) {
        LinkedList<String> paths = new LinkedList<String>();
        paths.add(p + "/core");
        switch (profile) {
            case DEFAULT: {
                paths.add(p + "/dataset");
                break;
            }
            case SAMPLING: {
                paths.add(p + "/sampling");
                break;
            }
        }
        return paths;
    }

    protected static File getDirectory(String path) throws URISyntaxException {
        return new File(AbstractGenerator.class.getResource(path).toURI());
    }

    public static void printToScreen(String lineToPrint) {
        System.out.println(lineToPrint);
    }

    protected int readSelectionFromStdIo() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
        String selection = br.readLine();
        return selection != null && !selection.isEmpty() ? Integer.parseInt(selection) : 0;
    }

    protected int readSelectionFromStdIoWithDefault(int defaultValue) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
        String selection = br.readLine();
        return selection != null && !selection.isEmpty() ? Integer.parseInt(selection) : defaultValue;
    }

    public static class ColumnMetadata
    implements Meta {
        private final String name;
        private String comment;
        private String sqlType;
        private String type;
        private String defaultValue;
        private String notNull;

        public ColumnMetadata(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = this.check(this.comment, comment);
        }

        public String getSqlType() {
            return this.sqlType;
        }

        public void setSqlType(String sqlType) {
            this.sqlType = this.check(this.sqlType, sqlType);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = this.check(this.type, type);
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = this.check(this.defaultValue, defaultValue);
        }

        public String getNotNull() {
            return this.notNull;
        }

        public void setNotNull(String notNull) {
            this.notNull = this.check(this.notNull, notNull);
        }
    }

    public static class TableMetadata
    implements Meta {
        private final String name;
        private final String comment;
        private Map<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();

        public TableMetadata(String name, String comment) {
            this.name = name;
            this.comment = comment;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public Map<String, ColumnMetadata> getColumns() {
            return this.columns;
        }

        public void setColumns(Map<String, ColumnMetadata> columns) {
            this.columns = columns;
        }

        public String toMarkdown() {
            StringBuilder builder = new StringBuilder();
            builder.append("### ").append(this.getName()).append("\n");
            builder.append("**Description**: ").append(this.checkForNullOrEmpty(this.getComment())).append("\n");
            builder.append("\n");
            builder.append("| column | comment | NOT-NULL | default | SQL type | Java type |").append("\n");
            builder.append("| --- | --- | --- | --- | --- | --- |").append("\n");
            for (ColumnMetadata cm : this.columns.values()) {
                builder.append("| ").append(cm.getName()).append(" | ");
                builder.append(this.checkForNullOrEmpty(cm.getComment())).append(" | ");
                builder.append(cm.getNotNull()).append(" | ");
                builder.append(this.checkForNullOrEmpty(cm.getDefaultValue())).append(" | ");
                builder.append(cm.getSqlType()).append(" | ");
                builder.append(cm.getType()).append(" | ").append("\n");
            }
            builder.append("\n[top](#Tables)\n");
            return builder.toString();
        }

        private String checkForNullOrEmpty(String value) {
            return value != null && !value.isEmpty() ? value : "-";
        }
    }

    public static interface Meta {
        default public String check(String origin, String current) {
            return origin != null && !origin.isEmpty() ? origin : (current != null && !current.isEmpty() ? current : null);
        }
    }

    static enum Profile {
        DEFAULT,
        SAMPLING;


        public String toString() {
            return this.name().replaceAll("_", "-").toLowerCase();
        }
    }

    static enum Concept {
        SIMPLE,
        TRANSACTIONAL,
        E_REPORTING,
        PROXY;


        public String toString() {
            return this.name().replaceAll("_", "-").toLowerCase();
        }
    }

    static enum DialectSelector {
        POSTGIS,
        ORACLE,
        GEODB,
        MY_SQL_SPATIAL_5,
        SQL_SERVER_2008;


        public String toString() {
            return this.name().replaceAll("_", "-").toLowerCase();
        }
    }
}

