/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.exi.EXIObject;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.ows.service.ResponseFormat;
import org.n52.svalbard.encode.AbstractDelegatingEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ExiResponseEncoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExiEncoder<T>
extends AbstractDelegatingEncoder<EXIObject<XmlObject>, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExiResponseEncoder.class);

    public MediaType getContentType() {
        return MediaTypes.APPLICATION_EXI;
    }

    public EXIObject<XmlObject> encode(T response, EncodingContext additionalValues) throws EncodingException {
        return this.encode(response);
    }

    public EXIObject<XmlObject> encode(T response) throws EncodingException {
        Encoder<Object, T> encoder = this.getEncoder(response);
        Object encode = encoder.encode(response);
        if (encode != null && encode instanceof XmlObject) {
            return new EXIObject((Object)((XmlObject)encode));
        }
        throw new UnsupportedEncoderInputException(encoder, response);
    }

    protected Encoder<Object, T> getEncoder(T response) throws EncodingException {
        EncoderKey key = this.getKey(response);
        Encoder encoder = this.getEncoder(key, new EncoderKey[0]);
        if (encoder == null) {
            throw new NoEncoderForKeyException((Object)key);
        }
        return encoder;
    }

    protected abstract EncoderKey getKey(T var1);

    protected MediaType getEncodedContentType(OwsServiceResponse response) {
        if (response instanceof ResponseFormat) {
            return this.getEncodedContentType((ResponseFormat)response);
        }
        return MediaTypes.APPLICATION_XML;
    }

    protected MediaType getEncodedContentType(ResponseFormat responseFormat) {
        if (responseFormat.isSetResponseFormat()) {
            MediaType contentTypeFromResponseFormat = null;
            try {
                contentTypeFromResponseFormat = MediaType.parse((String)responseFormat.getResponseFormat()).withoutParameters();
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Requested responseFormat {} is not a MediaType", (Object)responseFormat.getResponseFormat());
            }
            if (contentTypeFromResponseFormat != null) {
                if (MediaTypes.COMPATIBLE_TYPES.containsEntry((Object)contentTypeFromResponseFormat, (Object)MediaTypes.APPLICATION_XML)) {
                    return MediaTypes.APPLICATION_XML;
                }
                return contentTypeFromResponseFormat;
            }
        }
        return MediaTypes.APPLICATION_XML;
    }
}

