/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.n52.janmayen.http.MediaTypes;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.ExiEncoder;
import org.n52.svalbard.encode.OperationResponseEncoderKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExiResponseEncoder
extends ExiEncoder<OwsServiceResponse>
implements Constructable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExiResponseEncoder.class);
    private EncoderKey key;
    private String version;
    private String service;
    private String operation;

    @Inject
    public void setVersion(String version) {
        this.version = version;
    }

    @Inject
    public void setService(String service) {
        this.service = service;
    }

    @Inject
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void init() {
        this.key = new OperationResponseEncoderKey(this.service, this.version, this.operation, MediaTypes.APPLICATION_EXI);
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)this.key);
    }

    public Set<EncoderKey> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    protected EncoderKey getKey(OwsServiceResponse response) {
        return new OperationResponseEncoderKey(new OwsOperationKey((OwsServiceCommunicationObject)response), this.getEncodedContentType(response));
    }

    public String toString() {
        return String.format("%s{key=%s}", ExiResponseEncoder.class.getName(), this.key);
    }
}

