/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import java.net.URI;
import org.n52.janmayen.function.ThrowableFunction;
import org.n52.shetland.iso.gmd.LocalisedCharacterString;
import org.n52.shetland.iso.gmd.PT_FreeText;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.util.DateTimeParseException;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.JSONDecoder;

public abstract class AbstractJSONDecoder<T>
extends JSONDecoder<T> {
    public AbstractJSONDecoder(Class<T> type) {
        super(type);
    }

    protected Nillable<String> parseNillableString(JsonNode node) {
        return this.parseNillable(node).transform(JsonNode::textValue);
    }

    protected Nillable<PT_FreeText> parseNillablePTFreeText(JsonNode node) {
        return this.parseNillable(node).transform(this::parsePTFreeText);
    }

    protected Nillable<JsonNode> parseNillable(JsonNode node) {
        if (node.isMissingNode() || node.isNull()) {
            return Nillable.absent();
        }
        if (node.isObject() && node.path("nil").asBoolean()) {
            return Nillable.nil((String)node.path("reason").textValue());
        }
        return Nillable.of((Object)node);
    }

    protected Nillable<Reference> parseNillableReference(JsonNode node) {
        return this.parseNillable(node).transform(this::parseReference);
    }

    protected Referenceable<JsonNode> parseReferenceable(JsonNode node) {
        Nillable<JsonNode> nillable = this.parseNillable(node);
        if (nillable.isAbsent() || nillable.isNil()) {
            return Referenceable.of(nillable);
        }
        if (node.has("href")) {
            return Referenceable.of((Reference)this.parseReference(node));
        }
        return Referenceable.of((Object)node);
    }

    protected Reference parseReference(JsonNode node) {
        Reference ref = new Reference();
        ref.setHref(URI.create(node.path("href").textValue()));
        ref.setActuate(node.path("actuate").textValue());
        ref.setArcrole(node.path("arcrole").textValue());
        ref.setRemoteSchema(node.path("remoteSchema").textValue());
        ref.setRole(node.path("role").textValue());
        ref.setShow(node.path("show").textValue());
        ref.setTitle(node.path("title").textValue());
        ref.setType(node.path("type").textValue());
        return ref;
    }

    protected PT_FreeText parsePTFreeText(JsonNode node) {
        PT_FreeText ptFreeText = new PT_FreeText();
        ptFreeText.addTextGroup(new LocalisedCharacterString(node.textValue()));
        return ptFreeText;
    }

    protected Referenceable<Time> parseReferenceableTime(JsonNode node) {
        return this.parseReferenceable(node).transform(node1 -> {
            try {
                return this.parseTime((JsonNode)node1);
            }
            catch (DateTimeParseException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    protected Nillable<CodeType> parseNillableCodeType(JsonNode node) {
        return this.parseNillable(node).transform(arg_0 -> ((AbstractJSONDecoder)this).parseCodeType(arg_0));
    }

    protected <T> Nillable<T> decodeJsonToNillable(JsonNode node, final Class<T> type) throws DecodingException {
        ThrowableFunction fun = new ThrowableFunction<JsonNode, T>(){

            protected T applyThrowable(JsonNode input) throws DecodingException {
                return AbstractJSONDecoder.this.decodeJsonToObject(input, type);
            }
        };
        Nillable result = this.parseNillable(node).transform((Function)fun);
        if (fun.hasErrors()) {
            fun.propagateIfPossible(DecodingException.class);
        }
        return result;
    }

    protected <T> Referenceable<T> decodeJsonToReferencable(JsonNode node, final Class<T> type) throws DecodingException {
        ThrowableFunction fun = new ThrowableFunction<JsonNode, T>(){

            protected T applyThrowable(JsonNode input) throws DecodingException {
                return AbstractJSONDecoder.this.decodeJsonToObject(input, type);
            }
        };
        Referenceable result = this.parseReferenceable(node).transform((Function)fun);
        if (fun.hasErrors()) {
            fun.propagateIfPossible(DecodingException.class);
        }
        return result;
    }
}

