/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.n52.shetland.inspire.GeographicalName;
import org.n52.shetland.inspire.ad.AddressRepresentation;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractJSONDecoder;

public class AddressJSONDecoder
extends AbstractJSONDecoder<AddressRepresentation> {
    public AddressJSONDecoder() {
        super(AddressRepresentation.class);
    }

    public AddressRepresentation decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        AddressRepresentation address = new AddressRepresentation();
        address.setAddressFeature(this.parseNillableReference(node.path("addressFeature")));
        address.setPostCode(this.parseNillableString(node.path("postCode")));
        for (JsonNode n : node.path("addressAreas")) {
            address.addAddressArea(this.decodeJsonToNillable(n, GeographicalName.class));
        }
        for (JsonNode n : node.path("adminUnits")) {
            address.addAdminUnit((GeographicalName)this.decodeJsonToObject(n, GeographicalName.class));
        }
        for (JsonNode n : node.path("locatorDesignators")) {
            address.addLocatorDesignator(n.textValue());
        }
        for (JsonNode n : node.path("locatorNames")) {
            address.addLocatorName((GeographicalName)this.decodeJsonToObject(n, GeographicalName.class));
        }
        for (JsonNode n : node.path("postNames")) {
            address.addPostName(this.decodeJsonToNillable(n, GeographicalName.class));
        }
        for (JsonNode n : node.path("thoroughfares")) {
            address.addThoroughfare(this.decodeJsonToNillable(n, GeographicalName.class));
        }
        return address;
    }
}

