/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.request.BatchRequest;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.OperationDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.NoDecoderForKeyException;
import org.n52.svalbard.decode.json.AbstractSosRequestDecoder;

public class BatchRequestDecoder
extends AbstractSosRequestDecoder<BatchRequest> {
    public BatchRequestDecoder() {
        super(BatchRequest.class, "SOS", "2.0.0", "Batch");
    }

    protected String getSchemaURI() {
        return "http://www.52north.org/schema/json/sos/request/Batch#";
    }

    protected BatchRequest decodeRequest(JsonNode node) throws DecodingException {
        BatchRequest request = new BatchRequest();
        if (node.path("stopAtFailure").isBoolean()) {
            request.setStopAtFailure(node.path("stopAtFailure").booleanValue());
        }
        for (JsonNode n : node.path("requests")) {
            request.add((OwsServiceRequest)this.getDecoder(n).decode((Object)n));
        }
        return request;
    }

    private Decoder<OwsServiceRequest, JsonNode> getDecoder(JsonNode n) throws DecodingException {
        OperationDecoderKey k = new OperationDecoderKey(n.path("service").textValue(), n.path("version").textValue(), n.path("request").textValue(), MediaTypes.APPLICATION_JSON);
        Decoder decoder = this.getDecoder((DecoderKey)k, new DecoderKey[0]);
        if (decoder == null) {
            throw new NoDecoderForKeyException((DecoderKey)k);
        }
        return decoder;
    }
}

