/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.n52.shetland.inspire.ad.AddressRepresentation;
import org.n52.shetland.inspire.base2.Contact;
import org.n52.shetland.iso.gmd.LocalisedCharacterString;
import org.n52.shetland.iso.gmd.PT_FreeText;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractJSONDecoder;

public class ContactJSONDecoder
extends AbstractJSONDecoder<Contact> {
    public ContactJSONDecoder() {
        super(Contact.class);
    }

    public Contact decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        Contact contact = new Contact();
        contact.setAddress(this.decodeJsonToNillable(node.path("address"), AddressRepresentation.class));
        contact.setContactInstructions(this.parseNillableString(node.path("contactInstructions")).transform(this::parseFreeText));
        contact.setElectronicMailAddress(this.parseNillableString(node.path("electronicMailAddress")));
        contact.setHoursOfService(this.parseNillableString(node.path("hoursOfService")).transform(this::parseFreeText));
        contact.setWebsite(this.parseNillableString(node.path("website")));
        for (JsonNode n : node.path("telephoneFacsimile")) {
            contact.addTelephoneFacsimile(this.parseNillableString(n));
        }
        for (JsonNode n : node.path("telephoneVoice")) {
            contact.addTelephoneVoice(this.parseNillableString(n));
        }
        return contact;
    }

    private PT_FreeText parseFreeText(String s) {
        return new PT_FreeText().addTextGroup(new LocalisedCharacterString(s));
    }
}

