/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.n52.janmayen.stream.Streams;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.svalbard.coding.json.JSONValidator;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.GeoJSONDecoder;
import org.n52.svalbard.decode.json.JSONDecoder;

public class FeatureDecoder
extends JSONDecoder<AbstractFeature> {
    private final JSONDecoder<Geometry> geometryDecoder = new GeoJSONDecoder();

    public FeatureDecoder() {
        super(AbstractFeature.class);
    }

    public AbstractFeature decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        if (validate) {
            JSONValidator.getInstance().validateAndThrow(node, "http://www.52north.org/schema/json/FeatureOfInterest#");
        }
        return this.decodeJSON(node);
    }

    protected AbstractFeature decodeJSON(JsonNode node) throws DecodingException {
        if (node.isArray()) {
            return this.parseFeatureCollection(node);
        }
        return this.parseSamplingFeature(node);
    }

    protected SamplingFeature parseSamplingFeature(JsonNode node) throws DecodingException {
        if (node.isTextual()) {
            return new SamplingFeature(this.parseCodeWithAuthority(node));
        }
        if (node.isObject()) {
            SamplingFeature foi = new SamplingFeature(this.parseCodeWithAuthority(node.path("identifier")));
            foi.setGeometry(this.parseGeometry(node));
            foi.setSampledFeatures(this.parseSampledFeatures(node));
            foi.setName(this.parseNames(node));
            return foi;
        }
        return null;
    }

    private FeatureCollection parseFeatureCollection(JsonNode node) throws DecodingException {
        if (node.isArray()) {
            FeatureCollection collection = new FeatureCollection();
            for (JsonNode n : node) {
                collection.addMember((AbstractFeature)this.parseSamplingFeature(n));
            }
            return collection;
        }
        return null;
    }

    protected List<AbstractFeature> parseSampledFeatures(JsonNode node) throws DecodingException {
        JsonNode sfnode = node.path("sampledFeature");
        if (sfnode.isArray()) {
            ArrayList<AbstractFeature> features = new ArrayList<AbstractFeature>(sfnode.size());
            for (JsonNode n : sfnode) {
                features.add((AbstractFeature)this.parseSamplingFeature(n));
            }
            return features;
        }
        SamplingFeature sff = this.parseSamplingFeature(sfnode);
        if (sff == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(sff);
    }

    protected Geometry parseGeometry(JsonNode node) throws DecodingException {
        return (Geometry)this.geometryDecoder.decodeJSON(node.path("geometry"), false);
    }

    private List<CodeType> parseNames(JsonNode node) {
        JsonNode name = node.path("name");
        if (name.isArray()) {
            return Streams.stream((Iterable)name).map(arg_0 -> ((FeatureDecoder)this).parseCodeType(arg_0)).collect(Collectors.toList());
        }
        return Collections.singletonList(this.parseCodeType(name));
    }
}

