/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.n52.shetland.ogc.swe.RangeValue;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweCountRange;
import org.n52.shetland.ogc.swe.simpleType.SweObservableProperty;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweQuantityRange;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.ogc.swe.simpleType.SweTime;
import org.n52.shetland.ogc.swe.simpleType.SweTimeRange;
import org.n52.svalbard.coding.json.JSONValidator;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.decode.json.JSONDecoder;

public class FieldDecoder
extends JSONDecoder<SweField> {
    public FieldDecoder() {
        super(SweField.class);
    }

    public SweField decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        if (validate) {
            JSONValidator.getInstance().validateAndThrow(node, "http://www.52north.org/schema/json/Field#");
        }
        return this.decodeJSON(node);
    }

    public SweField decodeJSON(JsonNode node) throws DecodingException {
        SweAbstractDataComponent element;
        String type = node.path("type").textValue();
        if (type.equals("boolean")) {
            element = this.decodeBoolean(node);
        } else if (type.equals("count")) {
            element = this.decodeCount(node);
        } else if (type.equals("countRange")) {
            element = this.decodeCountRange(node);
        } else if (type.equals("observableProperty")) {
            element = this.decodeObservableProperty(node);
        } else if (type.equals("quality")) {
            element = this.decodeQuality(node);
        } else if (type.equals("text")) {
            element = this.decodeText(node);
        } else if (type.equals("quantity")) {
            element = this.decodeQuantity(node);
        } else if (type.equals("quantityRange")) {
            element = this.decodeQuantityRange(node);
        } else if (type.equals("time")) {
            element = this.decodeTime(node);
        } else if (type.equals("timeRange")) {
            element = this.decodeTimeRange(node);
        } else if (type.equals("category")) {
            element = this.decodeCategory(node);
        } else {
            throw new UnsupportedDecoderInputException((Decoder)this, (Object)node);
        }
        String name = node.path("name").textValue();
        element.setDescription(node.path("description").textValue());
        element.setIdentifier(node.path("identifier").textValue());
        element.setDefinition(node.path("definition").textValue());
        element.setLabel(node.path("label").textValue());
        return new SweField(name, element);
    }

    protected SweAbstractDataComponent decodeBoolean(JsonNode node) {
        SweBoolean swe = new SweBoolean();
        if (node.hasNonNull("value")) {
            swe.setValue(Boolean.valueOf(node.path("value").booleanValue()));
        }
        return swe;
    }

    protected SweAbstractDataComponent decodeCount(JsonNode node) {
        SweCount swe = new SweCount();
        if (node.hasNonNull("value")) {
            swe.setValue(Integer.valueOf(node.path("value").intValue()));
        }
        return swe;
    }

    protected SweAbstractDataComponent decodeCountRange(JsonNode node) {
        SweCountRange swe = new SweCountRange();
        if (node.hasNonNull("value")) {
            int start = node.path("value").path(0).intValue();
            int end = node.path("value").path(1).intValue();
            swe.setValue(new RangeValue((Object)start, (Object)end));
        }
        return swe;
    }

    protected SweAbstractDataComponent decodeQuantity(JsonNode node) {
        SweQuantity swe = new SweQuantity();
        if (node.hasNonNull("value")) {
            swe.setValue(Double.valueOf(node.path("value").doubleValue()));
        }
        return swe.setUom(node.path("uom").textValue());
    }

    protected SweAbstractDataComponent decodeText(JsonNode node) {
        return new SweText().setValue(node.path("value").textValue());
    }

    protected SweAbstractDataComponent decodeQuality(JsonNode node) throws DecodingException {
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)node);
    }

    protected SweAbstractDataComponent decodeObservableProperty(JsonNode node) {
        SweObservableProperty swe = new SweObservableProperty();
        return swe.setValue(node.path("value").textValue());
    }

    protected SweAbstractDataComponent decodeTime(JsonNode node) throws DecodingException {
        SweTime swe = new SweTime();
        if (node.hasNonNull("value")) {
            String value = node.path("value").textValue();
            swe.setValue(this.parseDateTime(value));
        }
        return swe.setUom(node.path("uom").textValue());
    }

    protected SweAbstractDataComponent decodeCategory(JsonNode node) {
        String value = node.path("value").textValue();
        String codespace = node.path("codespace").textValue();
        return new SweCategory().setValue(value).setCodeSpace(codespace);
    }

    protected SweAbstractDataComponent decodeQuantityRange(JsonNode node) {
        SweQuantityRange swe = new SweQuantityRange();
        if (node.hasNonNull("value")) {
            double start = node.path("value").path(0).doubleValue();
            double end = node.path("value").path(1).doubleValue();
            swe.setValue(new RangeValue((Object)start, (Object)end));
        }
        return swe.setUom(node.path("uom").textValue());
    }

    protected SweAbstractDataComponent decodeTimeRange(JsonNode node) throws DecodingException {
        SweTimeRange swe = new SweTimeRange();
        if (node.hasNonNull("value")) {
            String start = node.path("value").path(0).textValue();
            String end = node.path("value").path(1).textValue();
            swe.setValue(new RangeValue((Object)this.parseDateTime(start), (Object)this.parseDateTime(end)));
        }
        return swe.setUom(node.path("uom").textValue());
    }
}

