/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.n52.shetland.inspire.GeographicalName;
import org.n52.shetland.inspire.Pronunciation;
import org.n52.shetland.inspire.Spelling;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractJSONDecoder;

public class GeographicalNameJSONDecoder
extends AbstractJSONDecoder<GeographicalName> {
    public GeographicalNameJSONDecoder() {
        super(GeographicalName.class);
    }

    public GeographicalName decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        GeographicalName geographicalName = new GeographicalName();
        geographicalName.setGrammaticalGender(this.parseNillableCodeType(node.path("grammaticalGender")));
        geographicalName.setGrammaticalNumber(this.parseNillableCodeType(node.path("grammaticalNumber")));
        geographicalName.setLanguage(this.parseNillableString(node.path("language")));
        geographicalName.setNameStatus(this.parseNillableCodeType(node.path("nameStatus")));
        geographicalName.setNativeness(this.parseNillableCodeType(node.path("nativeness")));
        geographicalName.setSourceOfName(this.parseNillableString(node.path("sourceOfName")));
        geographicalName.setPronunciation(this.decodeJsonToNillable(node.path("pronunciation"), Pronunciation.class));
        for (JsonNode n : node.path("spelling")) {
            geographicalName.addSpelling((Spelling)this.decodeJsonToObject(n, Spelling.class));
        }
        return geographicalName;
    }
}

