/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.request.GetFeatureOfInterestRequest;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractSosRequestDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFeatureOfInterestRequestDecoder
extends AbstractSosRequestDecoder<GetFeatureOfInterestRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFeatureOfInterestRequestDecoder.class);

    public GetFeatureOfInterestRequestDecoder() {
        super(GetFeatureOfInterestRequest.class, "SOS", "2.0.0", (Enum)SosConstants.Operations.GetFeatureOfInterest);
    }

    protected String getSchemaURI() {
        return "http://www.52north.org/schema/json/sos/request/GetFeatureOfInterest#";
    }

    protected GetFeatureOfInterestRequest decodeRequest(JsonNode node) throws DecodingException {
        GetFeatureOfInterestRequest req = new GetFeatureOfInterestRequest();
        req.setFeatureIdentifiers(this.decodeFeatureOfInterests(node));
        req.setProcedures(this.decodeProcedures(node));
        req.setObservedProperties(this.decodeObservedProperties(node));
        req.setSpatialFilters(this.decodeSpatialFilters(node));
        req.setTemporalFilters(this.decodeTemporalFilters(node));
        return req;
    }

    private List<SpatialFilter> decodeSpatialFilters(JsonNode node) throws DecodingException {
        JsonNode path = node.path("spatialFilter");
        return this.decodeJsonToObjectList(path, SpatialFilter.class);
    }

    private List<TemporalFilter> decodeTemporalFilters(JsonNode node) throws DecodingException {
        JsonNode path = node.path("temporalFilter");
        return this.decodeJsonToObjectList(path, TemporalFilter.class);
    }

    private List<String> decodeObservedProperties(JsonNode node) {
        JsonNode path = node.path("observedProperty");
        return this.parseStringOrStringList(path);
    }

    private List<String> decodeProcedures(JsonNode node) {
        JsonNode path = node.path("procedure");
        return this.parseStringOrStringList(path);
    }

    private List<String> decodeFeatureOfInterests(JsonNode node) {
        JsonNode path = node.path("featureOfInterest");
        return this.parseStringOrStringList(path);
    }
}

