/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.n52.janmayen.Json;
import org.n52.shetland.ogc.filter.Filter;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.request.GetObservationRequest;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractSosRequestDecoder;

public class GetObservationRequestDecoder
extends AbstractSosRequestDecoder<GetObservationRequest> {
    public GetObservationRequestDecoder() {
        super(GetObservationRequest.class, "SOS", "2.0.0", (Enum)SosConstants.Operations.GetObservation);
    }

    public String getSchemaURI() {
        return "http://www.52north.org/schema/json/sos/request/GetObservation#";
    }

    public GetObservationRequest decodeRequest(JsonNode node) throws DecodingException {
        GetObservationRequest r = new GetObservationRequest();
        r.setFeatureIdentifiers(this.parseStringOrStringList(node.path("featureOfInterest")));
        r.setObservedProperties(this.parseStringOrStringList(node.path("observedProperty")));
        r.setOfferings(this.parseStringOrStringList(node.path("offering")));
        r.setProcedures(this.parseStringOrStringList(node.path("procedure")));
        r.setResponseFormat(node.path("responseFormat").textValue());
        r.setResponseMode(node.path("responseMode").textValue());
        r.setResultModel(node.path("resultModel").textValue());
        r.setResultFilter((Filter)this.parseComparisonFilter(node.path("resultFilter")));
        r.setSpatialFilter(this.parseSpatialFilter(node.path("spatialFilter")));
        r.setTemporalFilters(this.parseTemporalFilters(node.path("temporalFilter")));
        r.setRequestString(Json.print((JsonNode)node));
        return r;
    }

    private List<TemporalFilter> parseTemporalFilters(JsonNode node) throws DecodingException {
        return this.decodeJsonToObjectList(node, TemporalFilter.class);
    }

    private SpatialFilter parseSpatialFilter(JsonNode node) throws DecodingException {
        return (SpatialFilter)this.decodeJsonToObject(node, SpatialFilter.class);
    }
}

