/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.request.GetResultRequest;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractSosRequestDecoder;

public class GetResultRequestDecoder
extends AbstractSosRequestDecoder<GetResultRequest> {
    public GetResultRequestDecoder() {
        super(GetResultRequest.class, "SOS", "2.0.0", (Enum)SosConstants.Operations.GetResult);
    }

    protected String getSchemaURI() {
        return "http://www.52north.org/schema/json/sos/request/GetResult#";
    }

    protected GetResultRequest decodeRequest(JsonNode node) throws DecodingException {
        GetResultRequest req = new GetResultRequest();
        req.setFeatureIdentifiers(this.parseFeatureIdentifiers(node));
        req.setObservationTemplateIdentifier(this.parseObservationTemplateIdentifier(node));
        req.setObservedProperty(this.parseObservedProperty(node));
        req.setOffering(this.parseOffering(node));
        req.setSpatialFilter(this.parseSpatialFilter(node));
        req.setTemporalFilter(this.parseTemporalFilters(node));
        return req;
    }

    private List<String> parseFeatureIdentifiers(JsonNode node) {
        return this.parseStringOrStringList(node.path("featureOfInterest"));
    }

    private String parseObservationTemplateIdentifier(JsonNode node) {
        return node.path("observationTemplate").textValue();
    }

    private String parseObservedProperty(JsonNode node) {
        return node.path("observedProperty").textValue();
    }

    private String parseOffering(JsonNode node) {
        return node.path("offering").textValue();
    }

    private SpatialFilter parseSpatialFilter(JsonNode node) throws DecodingException {
        return (SpatialFilter)this.decodeJsonToObject(node.path("spatialFilter"), SpatialFilter.class);
    }

    private List<TemporalFilter> parseTemporalFilters(JsonNode node) throws DecodingException {
        return this.decodeJsonToObjectList(node.path("temporalFilter"), TemporalFilter.class);
    }
}

