/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.n52.shetland.ogc.om.OmObservationConstellation;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosResultEncoding;
import org.n52.shetland.ogc.sos.SosResultStructure;
import org.n52.shetland.ogc.sos.request.InsertResultTemplateRequest;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.encoding.SweAbstractEncoding;
import org.n52.shetland.ogc.swe.encoding.SweTextEncoding;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractSosRequestDecoder;
import org.n52.svalbard.decode.json.ObservationDecoder;

public class InsertResultTemplateRequestDecoder
extends AbstractSosRequestDecoder<InsertResultTemplateRequest> {
    private final ObservationDecoder observationDecoder = new ObservationDecoder();

    public InsertResultTemplateRequestDecoder() {
        super(InsertResultTemplateRequest.class, "SOS", "2.0.0", (Enum)Sos2Constants.Operations.InsertResultTemplate);
    }

    public String getSchemaURI() {
        return "http://www.52north.org/schema/json/sos/request/InsertResultTemplate#";
    }

    public InsertResultTemplateRequest decodeRequest(JsonNode node) throws DecodingException {
        InsertResultTemplateRequest irtr = new InsertResultTemplateRequest();
        if (!node.path("identifier").isMissingNode()) {
            irtr.setIdentifier(node.path("identifier").textValue());
        }
        irtr.setObservationTemplate(this.parseObservationTemplate(node));
        irtr.setResultStructure(this.parseResultStructure(node.path("resultStructure")));
        irtr.setResultEncoding(this.parseResultEncoding(node.path("resultEncoding")));
        return irtr;
    }

    private OmObservationConstellation parseObservationTemplate(JsonNode node) throws DecodingException {
        OmObservationConstellation oc = this.observationDecoder.parseObservationConstellation(node.path("observationTemplate"));
        oc.addOffering(node.path("offering").textValue());
        return oc;
    }

    private SosResultStructure parseResultStructure(JsonNode node) throws DecodingException {
        SweDataRecord dataRecord = this.parseFields(node.path("fields"));
        return new SosResultStructure((SweAbstractDataComponent)dataRecord);
    }

    private SosResultEncoding parseResultEncoding(JsonNode node) {
        SweTextEncoding textEncoding = new SweTextEncoding();
        textEncoding.setTokenSeparator(node.path("tokenSeparator").textValue());
        textEncoding.setBlockSeparator(node.path("blockSeparator").textValue());
        if (!node.path("decimalSeparator").isMissingNode()) {
            textEncoding.setDecimalSeparator(node.path("decimalSeparator").textValue());
        }
        return new SosResultEncoding((SweAbstractEncoding)textEncoding);
    }

    protected SweDataRecord parseFields(JsonNode node) throws DecodingException {
        SweDataRecord dataRecord = new SweDataRecord();
        for (JsonNode field : node) {
            dataRecord.addField((SweField)this.decodeJsonToObject(field, SweField.class));
        }
        return dataRecord;
    }
}

