/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosInsertionMetadata;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.request.InsertSensorRequest;
import org.n52.shetland.ogc.swes.SwesFeatureRelationship;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractSosRequestDecoder;
import org.n52.svalbard.decode.json.FeatureDecoder;
import org.n52.svalbard.decode.json.JSONDecoder;

public class InsertSensorRequestDecoder
extends AbstractSosRequestDecoder<InsertSensorRequest> {
    private final JSONDecoder<AbstractFeature> featureDecoder = new FeatureDecoder();

    public InsertSensorRequestDecoder() {
        super(InsertSensorRequest.class, "SOS", "2.0.0", (Enum)Sos2Constants.Operations.InsertSensor);
    }

    protected String getSchemaURI() {
        return "http://www.52north.org/schema/json/sos/request/InsertSensor#";
    }

    protected InsertSensorRequest decodeRequest(JsonNode node) throws DecodingException {
        InsertSensorRequest r = new InsertSensorRequest();
        SosInsertionMetadata meta = new SosInsertionMetadata();
        meta.setFeatureOfInterestTypes((Collection)this.parseStringOrStringList(node.path("featureOfInterestType")));
        meta.setObservationTypes((Collection)this.parseStringOrStringList(node.path("observationType")));
        r.setMetadata(meta);
        r.setObservableProperty(this.parseStringOrStringList(node.path("observableProperty")));
        r.setProcedureDescriptionFormat(node.path("procedureDescriptionFormat").textValue());
        r.setRelatedFeature(this.parseFeatureRelationships(node.path("relatedFeature")));
        r.setProcedureDescription(this.parseProcedureDescription(node.path("procedureDescription"), r.getProcedureDescriptionFormat()));
        return r;
    }

    protected List<SwesFeatureRelationship> parseFeatureRelationships(JsonNode node) throws DecodingException {
        if (node.isArray()) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)node.size());
            for (JsonNode n : node) {
                if (!n.isObject()) continue;
                list.add(this.parseFeatureRelationship(n));
            }
            return list;
        }
        if (node.isObject()) {
            return Collections.singletonList(this.parseFeatureRelationship(node));
        }
        return null;
    }

    protected SwesFeatureRelationship parseFeatureRelationship(JsonNode node) throws DecodingException {
        return new SwesFeatureRelationship(node.path("role").textValue(), (AbstractFeature)this.featureDecoder.decodeJSON(node.path("target"), false));
    }

    private SosProcedureDescription<?> parseProcedureDescription(JsonNode path, String pdf) throws DecodingException {
        try {
            XmlObject xb = XmlObject.Factory.parse((String)path.textValue());
            Decoder<?, XmlObject> decoder = this.getProcedureDescriptionDecoder(pdf, xb);
            if (decoder == null) {
                throw new DecodingException("procedureDescriptionFormat", "The requested %s is not supported!", new Object[]{"procedureDescriptionFormat"});
            }
            Object decode = decoder.decode((Object)xb);
            if (decode instanceof SosProcedureDescription) {
                return (SosProcedureDescription)decode;
            }
            if (decode instanceof AbstractFeature) {
                return new SosProcedureDescription((AbstractFeature)decode);
            }
            throw new DecodingException("The decoded element {} is not of type {}!", decode.getClass().getName(), new Object[]{AbstractFeature.class.getName()});
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing procedure description of InsertSensor request!", (Throwable)xmle);
        }
    }

    protected Decoder<?, XmlObject> getProcedureDescriptionDecoder(String pdf, XmlObject xb) {
        return this.getDecoder((DecoderKey)new XmlNamespaceDecoderKey(pdf, xb.getClass()), new DecoderKey[0]);
    }
}

