/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.n52.faroe.Validation;
import org.n52.shetland.inspire.base.Identifier;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractJSONDecoder;

public class InspireIDJSONDecoder
extends AbstractJSONDecoder<Identifier> {
    public InspireIDJSONDecoder() {
        super(Identifier.class);
    }

    public Identifier decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        Identifier inspireID = new Identifier(this.getLocalId(node), this.getNamespace(node));
        inspireID.setVersionId(this.parseNillableString(node.path("versionId")));
        return inspireID;
    }

    private String getNamespace(JsonNode node) throws DecodingException {
        String namespace = node.path("namespace").textValue();
        Validation.notNullOrEmpty((String)"Identifier namespace", (String)namespace);
        return namespace;
    }

    private String getLocalId(JsonNode node) throws DecodingException {
        String localId = node.path("localId").textValue();
        Validation.notNullOrEmpty((String)"Identifier localId", (String)localId);
        return localId;
    }
}

