/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.AbstractPhenomenon;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.om.OmObservableProperty;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.OmObservationConstellation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.GeometryValue;
import org.n52.shetland.ogc.om.values.HrefAttributeValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.ReferenceValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.sensorML.SensorML;
import org.n52.shetland.w3c.xlink.W3CHrefAttribute;
import org.n52.svalbard.coding.json.JSONValidator;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.FeatureDecoder;
import org.n52.svalbard.decode.json.GeoJSONDecoder;
import org.n52.svalbard.decode.json.JSONDecoder;
import org.n52.svalbard.decode.json.JSONDecodingException;

public class ObservationDecoder
extends JSONDecoder<OmObservation> {
    private static final Set<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)OmConstants.OBS_TYPE_GEOMETRY_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_CATEGORY_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_COUNT_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_MEASUREMENT_TYPE).add((Object)OmConstants.OBS_TYPE_TEXT_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_TRUTH_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_REFERENCE_OBSERVATION_TYPE).build();
    private final JSONDecoder<AbstractFeature> featureDecoder = new FeatureDecoder();
    private final JSONDecoder<Geometry> geometryDecoder = new GeoJSONDecoder();

    public ObservationDecoder() {
        super(OmObservation.class);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public OmObservation decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        if (node == null) {
            return null;
        }
        if (validate) {
            JSONValidator.getInstance().validateAndThrow(node, "http://www.52north.org/schema/json/Observation#");
        }
        return this.decodeJSON(node);
    }

    protected OmObservation decodeJSON(JsonNode node) throws DecodingException {
        if (node.isObject()) {
            OmObservation o = new OmObservation();
            o.setIdentifier(this.parseIdentifier(node));
            o.setValidTime(this.parseValidTime(node));
            o.setResultTime(this.parseResultTime(node));
            o.setValue(this.parseValue(node));
            o.setParameter(this.parseParameter(node));
            o.setObservationConstellation(this.parseObservationConstellation(node));
            return o;
        }
        return null;
    }

    public OmObservationConstellation parseObservationConstellation(JsonNode node) throws DecodingException {
        OmObservationConstellation oc = new OmObservationConstellation();
        oc.setProcedure(this.parseProcedure(node));
        oc.setObservableProperty(this.parseObservableProperty(node));
        oc.setObservationType(this.parseObservationType(node));
        oc.setFeatureOfInterest(this.parseFeatureOfInterest(node));
        return oc;
    }

    protected AbstractFeature parseProcedure(JsonNode node) {
        return new SensorML().setIdentifier(node.path("procedure").textValue());
    }

    private AbstractPhenomenon parseObservableProperty(JsonNode node) {
        return new OmObservableProperty(node.path("observedProperty").textValue());
    }

    private CodeWithAuthority parseIdentifier(JsonNode node) {
        return this.parseCodeWithAuthority(node.path("identifier"));
    }

    protected String parseObservationType(JsonNode node) {
        return node.path("type").textValue();
    }

    protected TimePeriod parseValidTime(JsonNode node) throws DecodingException {
        return this.parseTimePeriod(node.path("validTime"));
    }

    protected TimeInstant parseResultTime(JsonNode node) throws DecodingException {
        return this.parseTimeInstant(node.path("resultTime"));
    }

    private Time parsePhenomenonTime(JsonNode node) throws DecodingException {
        return this.parseTime(node.path("phenomenonTime"));
    }

    protected Collection<NamedValue<?>> parseParameter(JsonNode node) throws DecodingException {
        TreeSet parameters = Sets.newTreeSet();
        JsonNode parameter = node.path("parameter");
        if (parameter.isArray()) {
            for (JsonNode jsonNode : parameter) {
                parameters.add(this.parseNamedValue(jsonNode));
            }
        } else if (parameter.isObject()) {
            parameters.add(this.parseNamedValue(parameter));
        }
        return parameters;
    }

    private NamedValue<?> parseNamedValue(JsonNode parameter) throws DecodingException {
        JsonNode namedValue = parameter.path("NamedValue");
        NamedValue<?> nv = this.parseNamedValueValue(namedValue.path("value"));
        ReferenceType referenceType = new ReferenceType(namedValue.path("name").asText());
        nv.setName(referenceType);
        return nv;
    }

    private NamedValue<?> parseNamedValueValue(JsonNode value) throws DecodingException {
        if (value.isTextual()) {
            NamedValue nv = new NamedValue();
            nv.setValue((Value)new HrefAttributeValue(new W3CHrefAttribute(value.asText())));
            return nv;
        }
        if (value.isBoolean()) {
            NamedValue nv = new NamedValue();
            nv.setValue((Value)new BooleanValue(Boolean.valueOf(value.asBoolean())));
            return nv;
        }
        if (value.isInt()) {
            NamedValue nv = new NamedValue();
            nv.setValue((Value)new CountValue(Integer.valueOf(value.asInt())));
            return nv;
        }
        if (value.isObject()) {
            if (value.has("codespace")) {
                NamedValue nv = new NamedValue();
                nv.setValue((Value)this.parseCategroyValue(value));
                return nv;
            }
            if (value.has("uom")) {
                NamedValue nv = new NamedValue();
                nv.setValue((Value)this.parseQuantityValue(value));
                return nv;
            }
            if (value.has("coordinates")) {
                NamedValue nv = new NamedValue();
                nv.setValue((Value)new GeometryValue((Geometry)this.geometryDecoder.decodeJSON(value, false)));
                return nv;
            }
        }
        throw new DecodingException("%s is not yet supported", value.toString(), new Object[0]);
    }

    protected AbstractFeature parseFeatureOfInterest(JsonNode node) throws DecodingException {
        return (AbstractFeature)this.featureDecoder.decodeJSON(node.path("featureOfInterest"), false);
    }

    private ObservationValue<?> parseValue(JsonNode node) throws DecodingException {
        String type = this.parseObservationType(node);
        if (type.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement")) {
            return this.parseMeasurementValue(node);
        }
        if (type.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TextObservation")) {
            return this.parseTextObservationValue(node);
        }
        if (type.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation")) {
            return this.parseCountObservationValue(node);
        }
        if (type.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TruthObservation")) {
            return this.parseTruthObservationValue(node);
        }
        if (type.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation")) {
            return this.parseCategoryObservationValue(node);
        }
        if (type.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ReferenceObservation")) {
            return this.parseReferenceObservationValue(node);
        }
        if (type.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_GeometryObservation")) {
            return this.parseGeometryObservation(node);
        }
        throw new JSONDecodingException("Unsupported observationType: " + type);
    }

    protected ObservationValue<?> parseMeasurementValue(JsonNode node) throws DecodingException {
        QuantityValue qv = this.parseQuantityValue(node.path("result"));
        return new SingleObservationValue(this.parsePhenomenonTime(node), (Value)qv);
    }

    private QuantityValue parseQuantityValue(JsonNode node) throws DecodingException {
        return new QuantityValue(Double.valueOf(node.path("value").doubleValue()), node.path("uom").textValue());
    }

    private ObservationValue<?> parseTextObservationValue(JsonNode node) throws DecodingException {
        TextValue v = new TextValue(node.path("result").textValue());
        return new SingleObservationValue(this.parsePhenomenonTime(node), (Value)v);
    }

    private ObservationValue<?> parseCountObservationValue(JsonNode node) throws DecodingException {
        CountValue v = new CountValue(Integer.valueOf(node.path("result").intValue()));
        return new SingleObservationValue(this.parsePhenomenonTime(node), (Value)v);
    }

    private ObservationValue<?> parseTruthObservationValue(JsonNode node) throws DecodingException {
        BooleanValue v = new BooleanValue(Boolean.valueOf(node.path("result").booleanValue()));
        return new SingleObservationValue(this.parsePhenomenonTime(node), (Value)v);
    }

    private ObservationValue<?> parseCategoryObservationValue(JsonNode node) throws DecodingException {
        CategoryValue v = this.parseCategroyValue(node.path("result"));
        return new SingleObservationValue(this.parsePhenomenonTime(node), (Value)v);
    }

    private CategoryValue parseCategroyValue(JsonNode node) throws DecodingException {
        return new CategoryValue(node.path("value").textValue(), node.path("codespace").textValue());
    }

    private ObservationValue<?> parseGeometryObservation(JsonNode node) throws DecodingException {
        GeometryValue v = new GeometryValue((Geometry)this.geometryDecoder.decodeJSON(node.path("result"), false));
        return new SingleObservationValue(this.parsePhenomenonTime(node), (Value)v);
    }

    private ObservationValue<?> parseReferenceObservationValue(JsonNode node) throws DecodingException {
        ReferenceValue v = new ReferenceValue(this.parseReferenceValue(node.path("result")));
        return new SingleObservationValue(this.parsePhenomenonTime(node), (Value)v);
    }

    private ReferenceType parseReferenceValue(JsonNode node) {
        ReferenceType ref = new ReferenceType();
        if (!node.path("href").isMissingNode()) {
            ref.setHref(node.path("href").asText());
        }
        if (!node.path("title").isMissingNode()) {
            ref.setTitle(node.path("title").asText());
        }
        if (!node.path("role").isMissingNode()) {
            ref.setRole(node.path("role").asText());
        }
        return ref;
    }
}

