/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import java.net.URI;
import org.n52.shetland.inspire.Pronunciation;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractJSONDecoder;

public class PronunciationJSONDecoder
extends AbstractJSONDecoder<Pronunciation> {
    private static final Function<String, URI> STRING_TO_URI = new Function<String, URI>(){

        public URI apply(String input) {
            return URI.create(input);
        }
    };

    public PronunciationJSONDecoder() {
        super(Pronunciation.class);
    }

    public Pronunciation decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        Pronunciation pronunciation = new Pronunciation();
        pronunciation.setIPA(this.parseNillableString(node.path("ipa")));
        pronunciation.setSoundLink(this.parseNillableString(node.path("soundLink")).transform(PronunciationJSONDecoder.stringToURI()));
        return pronunciation;
    }

    public static Function<String, URI> stringToURI() {
        return STRING_TO_URI;
    }
}

