/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.n52.shetland.inspire.base2.Contact;
import org.n52.shetland.inspire.base2.RelatedParty;
import org.n52.shetland.iso.gmd.LocalisedCharacterString;
import org.n52.shetland.iso.gmd.PT_FreeText;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractJSONDecoder;

public class RelatedPartyJSONDecoder
extends AbstractJSONDecoder<RelatedParty> {
    public RelatedPartyJSONDecoder() {
        super(RelatedParty.class);
    }

    public RelatedParty decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        RelatedParty relatedParty = new RelatedParty();
        relatedParty.setContact(this.decodeJsonToNillable(node.path("contact"), Contact.class));
        relatedParty.setIndividualName(this.parseNillableString(node.path("individualName")).transform(this::parseFreeText));
        relatedParty.setOrganisationName(this.parseNillableString(node.path("organisationName")).transform(this::parseFreeText));
        relatedParty.setPositionName(this.parseNillableString(node.path("positionName")).transform(this::parseFreeText));
        for (JsonNode n : node.path("roles")) {
            relatedParty.addRole(this.parseNillableReference(n));
        }
        return relatedParty;
    }

    private PT_FreeText parseFreeText(String s) {
        return new PT_FreeText().addTextGroup(new LocalisedCharacterString(s));
    }
}

