/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.svalbard.coding.json.JSONValidator;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.JSONDecoder;

public class SpatialFilterDecoder
extends JSONDecoder<SpatialFilter> {
    public SpatialFilterDecoder() {
        super(SpatialFilter.class);
    }

    public SpatialFilter decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        if (node == null || node.isNull() || node.isMissingNode()) {
            return null;
        }
        if (validate) {
            JSONValidator.getInstance().validateAndThrow(node, "http://www.52north.org/schema/json/SpatialFilter#");
        }
        if (node.isObject()) {
            String oName = (String)((Map.Entry)node.fields().next()).getKey();
            SOp o = SOp.valueOf(oName);
            JsonNode value = node.path(oName).path("value");
            JsonNode ref = node.path(oName).path("ref");
            return new SpatialFilter(o.getOp(), this.decodeGeometry(value), ref.textValue());
        }
        return null;
    }

    private Geometry decodeGeometry(JsonNode value) throws DecodingException {
        return (Geometry)this.decodeJsonToObject(value, Geometry.class);
    }

    private static enum SOp {
        equals(FilterConstants.SpatialOperator.Equals),
        disjount(FilterConstants.SpatialOperator.Disjoint),
        touches(FilterConstants.SpatialOperator.Touches),
        within(FilterConstants.SpatialOperator.Within),
        overlaps(FilterConstants.SpatialOperator.Overlaps),
        crosses(FilterConstants.SpatialOperator.Crosses),
        intersects(FilterConstants.SpatialOperator.Intersects),
        contains(FilterConstants.SpatialOperator.Contains),
        dWithin(FilterConstants.SpatialOperator.DWithin),
        beyond(FilterConstants.SpatialOperator.Beyond),
        bbox(FilterConstants.SpatialOperator.BBOX);

        private FilterConstants.SpatialOperator op;

        private SOp(FilterConstants.SpatialOperator op) {
            this.op = op;
        }

        public FilterConstants.SpatialOperator getOp() {
            return this.op;
        }
    }
}

