/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.svalbard.coding.json.JSONValidator;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.JSONDecoder;

public class TemporalFilterDecoder
extends JSONDecoder<TemporalFilter> {
    public TemporalFilterDecoder() {
        super(TemporalFilter.class);
    }

    public TemporalFilter decodeJSON(JsonNode node, boolean validate) throws DecodingException {
        if (node == null || node.isNull() || node.isMissingNode()) {
            return null;
        }
        if (validate) {
            JSONValidator.getInstance().validateAndThrow(node, "http://www.52north.org/schema/json/TemporalFilter#");
        }
        if (node.isObject()) {
            return this.parseTemporalFilter(node);
        }
        return null;
    }

    protected TemporalFilter parseTemporalFilter(JsonNode node) throws DecodingException {
        if (node.isObject()) {
            String oName = (String)((Map.Entry)node.fields().next()).getKey();
            TOp o = TOp.valueOf(oName);
            return new TemporalFilter(o.getOp(), this.parseTime(node.path(oName).path("value")), node.path(oName).path("ref").textValue());
        }
        return null;
    }

    private static enum TOp {
        before(FilterConstants.TimeOperator.TM_Before),
        after(FilterConstants.TimeOperator.TM_After),
        begins(FilterConstants.TimeOperator.TM_Begins),
        ends(FilterConstants.TimeOperator.TM_Ends),
        endedBy(FilterConstants.TimeOperator.TM_EndedBy),
        begunBy(FilterConstants.TimeOperator.TM_BegunBy),
        during(FilterConstants.TimeOperator.TM_During),
        equals(FilterConstants.TimeOperator.TM_Equals),
        contains(FilterConstants.TimeOperator.TM_Contains),
        overlaps(FilterConstants.TimeOperator.TM_Overlaps),
        meets(FilterConstants.TimeOperator.TM_Meets),
        metBy(FilterConstants.TimeOperator.TM_MetBy),
        overlappedBy(FilterConstants.TimeOperator.TM_OverlappedBy);

        private FilterConstants.TimeOperator op;

        private TOp(FilterConstants.TimeOperator op) {
            this.op = op;
        }

        public FilterConstants.TimeOperator getOp() {
            return this.op;
        }
    }
}

