/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.json;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.request.UpdateSensorRequest;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.json.AbstractSosRequestDecoder;

public class UpdateSensorRequestDecoder
extends AbstractSosRequestDecoder<UpdateSensorRequest> {
    public UpdateSensorRequestDecoder() {
        super(UpdateSensorRequest.class, "SOS", "2.0.0", (Enum)Sos2Constants.Operations.UpdateSensorDescription);
    }

    protected String getSchemaURI() {
        return "http://www.52north.org/schema/json/sos/request/UpdateSensorDescription#";
    }

    protected UpdateSensorRequest decodeRequest(JsonNode node) throws DecodingException {
        UpdateSensorRequest req = new UpdateSensorRequest();
        req.setProcedureIdentifier(node.path("procedure").textValue());
        String pdf = node.path("procedureDescriptionFormat").textValue();
        req.setProcedureDescriptionFormat(pdf);
        JsonNode procedureDescriptionNode = node.path("procedureDescription");
        if (procedureDescriptionNode.isArray()) {
            for (JsonNode n : procedureDescriptionNode) {
                req.addProcedureDescriptionString(this.decodeProcedureDescription(n, pdf));
            }
        } else {
            req.addProcedureDescriptionString(this.decodeProcedureDescription(procedureDescriptionNode, pdf));
        }
        return req;
    }

    private SosProcedureDescription<?> decodeProcedureDescription(JsonNode node, String pdf) throws DecodingException {
        if (node.isTextual()) {
            return this.parseProcedureDesciption(node.textValue(), pdf);
        }
        SosProcedureDescription<?> pd = this.parseProcedureDesciption(node.path("description").textValue(), pdf);
        if (node.has("validTime")) {
            pd.setValidTime(this.parseTime(node.path("validTime")));
        }
        return pd;
    }

    private SosProcedureDescription<?> parseProcedureDesciption(String xml, String pdf) throws DecodingException {
        try {
            XmlObject xb = XmlObject.Factory.parse((String)xml);
            Decoder decoder = this.getDecoder((DecoderKey)new XmlNamespaceDecoderKey(pdf, xb.getClass()), new DecoderKey[0]);
            if (decoder == null) {
                throw new DecodingException("procedureDescriptionFormat", "The requested %s is not supported!", new Object[]{"procedureDescriptionFormat"});
            }
            Object decode = decoder.decode((Object)xb);
            if (decode instanceof SosProcedureDescription) {
                return (SosProcedureDescription)decode;
            }
            if (decode instanceof AbstractFeature) {
                return new SosProcedureDescription((AbstractFeature)decode);
            }
            throw new DecodingException("The decoded element {} is not of type {}!", decode.getClass().getName(), new Object[]{AbstractFeature.class.getName()});
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing procedure description of InsertSensor request!", (Throwable)xmle);
        }
    }
}

