/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.ObservationType;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.response.AbstractObservationResponse;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.json.AbstractSosResponseEncoder;

public abstract class AbstractObservationResponseEncoder<T extends AbstractObservationResponse>
extends AbstractSosResponseEncoder<T>
implements ObservationEncoder<JsonNode, T> {
    public AbstractObservationResponseEncoder(Class<T> type, String operation) {
        super(type, operation);
    }

    public AbstractObservationResponseEncoder(Class<T> type, Enum<?> operation) {
        super(type, operation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void encodeResponse(ObjectNode json, T t) throws EncodingException {
        ArrayNode obs = json.putArray("observations");
        try {
            block2: while (t.getObservationCollection().hasNext()) {
                OmObservation o = (OmObservation)t.getObservationCollection().next();
                if (o.getValue() instanceof ObservationStream) {
                    ObservationStream value = (ObservationStream)o.getValue();
                    while (true) {
                        if (!value.hasNext()) continue block2;
                        obs.add(this.encodeObjectToJson(value.next()));
                    }
                }
                obs.add(this.encodeObjectToJson(o));
            }
            return;
        }
        catch (OwsExceptionReport ex) {
            throw new EncodingException((Throwable)ex);
        }
    }

    public boolean isObservationAndMeasurmentV20Type() {
        return false;
    }

    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    public boolean shouldObservationsWithSameXBeMerged() {
        return false;
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        return Collections.singleton(MediaTypes.APPLICATION_JSON.toString());
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap(MediaTypes.APPLICATION_JSON.toString(), Sets.newHashSet((Object[])new SupportedType[]{new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_GeometryObservation"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TextObservation"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TruthObservation"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_SWEArrayObservation"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ReferenceObservation")}));
    }
}

