/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.n52.shetland.ogc.ows.exception.CompositeOwsException;
import org.n52.shetland.ogc.ows.exception.MissingParameterValueException;
import org.n52.shetland.ogc.ows.exception.MissingServiceParameterException;
import org.n52.shetland.ogc.ows.exception.MissingVersionParameterException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.delobs.DeleteObservationConstants;
import org.n52.shetland.ogc.sos.delobs.DeleteObservationResponse;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.encode.json.AbstractSosResponseEncoder;

public class DeleteObservationJsonEncoder
extends AbstractSosResponseEncoder<DeleteObservationResponse> {
    public DeleteObservationJsonEncoder() {
        super(DeleteObservationResponse.class, (Enum)DeleteObservationConstants.Operations.DeleteObservation);
    }

    protected void encodeResponse(ObjectNode json, DeleteObservationResponse t) throws EncodingException {
        if (t == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, DeleteObservationResponse.class);
        }
        CompositeOwsException exceptions = new CompositeOwsException();
        if (t.getService() == null) {
            exceptions.add(new OwsExceptionReport[]{new MissingServiceParameterException()});
        }
        if (t.getVersion() == null) {
            exceptions.add(new OwsExceptionReport[]{new MissingVersionParameterException()});
        }
        if ("http://www.opengis.net/sosdo/1.0".equals(t.getOperationVersion())) {
            if (t.getObservationId() == null || t.getObservationId().isEmpty()) {
                exceptions.add(new OwsExceptionReport[]{new MissingParameterValueException("observation")});
            } else {
                json.put("deletedObservation", t.getObservationId());
            }
        }
        try {
            exceptions.throwIfNotEmpty();
        }
        catch (CompositeOwsException e) {
            throw new EncodingException((Throwable)e);
        }
    }
}

