/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.SosProcedureDescriptionUnknownType;
import org.n52.shetland.ogc.sos.response.DescribeSensorResponse;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncoderRepository;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.json.AbstractSosResponseEncoder;
import org.n52.svalbard.util.CodingHelper;

public class DescribeSensorResponseEncoder
extends AbstractSosResponseEncoder<DescribeSensorResponse> {
    private EncoderRepository encoderRepository;
    private Supplier<XmlOptions> xmlOptions;

    public DescribeSensorResponseEncoder() {
        super(DescribeSensorResponse.class, (Enum)SosConstants.Operations.DescribeSensor);
    }

    @Inject
    public void setEncoderRepository(EncoderRepository encoderRepository) {
        this.encoderRepository = encoderRepository;
    }

    @Inject
    public void setXmlOptions(Supplier<XmlOptions> xmlOptions) {
        this.xmlOptions = xmlOptions;
    }

    protected void encodeResponse(ObjectNode json, DescribeSensorResponse t) throws EncodingException {
        json.put("procedureDescriptionFormat", t.getOutputFormat());
        json.set("procedureDescription", this.encodeDescriptions(t.getProcedureDescriptions(), t.getOutputFormat()));
    }

    private String toString(AbstractFeature desc, String format) throws EncodingException {
        if (desc instanceof SosProcedureDescriptionUnknownType && desc.isSetXml()) {
            return desc.getXml();
        }
        return ((XmlObject)this.encoderRepository.getEncoder(CodingHelper.getEncoderKey((String)format, (Object)desc), new EncoderKey[0]).encode((Object)desc)).xmlText(this.xmlOptions.get());
    }

    private JsonNode encodeDescription(SosProcedureDescription<?> desc, String format) throws EncodingException {
        String xml = this.toString((AbstractFeature)desc, format);
        if (desc.isSetValidTime()) {
            ObjectNode j = this.nodeFactory().objectNode();
            j.set("validTime", this.encodeObjectToJson(desc.getValidTime()));
            j.put("description", xml);
            return j;
        }
        return this.nodeFactory().textNode(xml);
    }

    private JsonNode encodeDescriptions(List<SosProcedureDescription<?>> descs, String format) throws EncodingException {
        if (descs.size() == 1) {
            return this.encodeDescription(descs.get(0), format);
        }
        ArrayNode a = this.nodeFactory().arrayNode();
        for (SosProcedureDescription<?> desc : descs) {
            a.add(this.encodeDescription(desc, format));
        }
        return a;
    }
}

