/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.encode.json.JSONEncoder;

public class FeatureOfInterestEncoder
extends JSONEncoder<AbstractFeature> {
    public FeatureOfInterestEncoder() {
        super(AbstractFeature.class, new EncoderKey[0]);
    }

    public JsonNode encodeJSON(AbstractFeature t) throws EncodingException {
        if (t instanceof FeatureCollection) {
            return this.encodeFeatureCollection(t);
        }
        if (t instanceof AbstractSamplingFeature) {
            return this.encodeAbstractSamplingFeature(t);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)t);
    }

    private JsonNode encodeAbstractSamplingFeature(AbstractFeature t) throws EncodingException {
        AbstractSamplingFeature sf = (AbstractSamplingFeature)t;
        if (sf.isSetUrl()) {
            return this.nodeFactory().textNode(sf.getUrl());
        }
        if (!sf.isSetGeometry()) {
            return this.nodeFactory().textNode(sf.getIdentifierCodeWithAuthority().getValue());
        }
        ObjectNode json = this.nodeFactory().objectNode();
        this.encodeIdentifier(sf, json);
        this.encodeNames(sf, json);
        this.encodeSampledFeatures(sf, json);
        this.encodeGeometry(sf, json);
        return json;
    }

    private JsonNode encodeFeatureCollection(AbstractFeature t) throws EncodingException {
        FeatureCollection featureCollection = (FeatureCollection)t;
        ArrayNode a = this.nodeFactory().arrayNode();
        for (AbstractFeature af : featureCollection) {
            a.add(this.encodeObjectToJson(af));
        }
        return a;
    }

    private void encodeIdentifier(AbstractSamplingFeature sf, ObjectNode json) {
        if (sf.isSetIdentifier()) {
            json.set("identifier", this.encodeCodeWithAuthority(sf.getIdentifierCodeWithAuthority()));
        }
    }

    private void encodeNames(AbstractSamplingFeature samplingFeature, ObjectNode json) {
        if (samplingFeature.isSetName()) {
            if (samplingFeature.getName().size() == 1) {
                json.set("name", this.encodeCodeType((CodeType)samplingFeature.getName().iterator().next()));
            } else {
                ArrayNode names = json.putArray("name");
                for (CodeType name : samplingFeature.getName()) {
                    names.add(this.encodeCodeType(name));
                }
            }
        }
    }

    private void encodeSampledFeatures(AbstractSamplingFeature sf, ObjectNode json) throws EncodingException {
        if (sf.isSetSampledFeatures()) {
            if (sf.getSampledFeatures().size() == 1) {
                json.set("sampledFeature", this.encodeObjectToJson(sf.getSampledFeatures().iterator().next()));
            } else {
                ArrayNode sampledFeatures = json.putArray("sampledFeature");
                for (AbstractFeature sampledFeature : sf.getSampledFeatures()) {
                    sampledFeatures.add(this.encodeObjectToJson(sampledFeature));
                }
            }
        }
    }

    private void encodeGeometry(AbstractSamplingFeature sf, ObjectNode json) throws EncodingException {
        if (sf.isSetGeometry()) {
            json.set("geometry", this.encodeObjectToJson(sf.getGeometry()));
        }
    }
}

