/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.joda.time.DateTime;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweCountRange;
import org.n52.shetland.ogc.swe.simpleType.SweObservableProperty;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweQuantityRange;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.ogc.swe.simpleType.SweTime;
import org.n52.shetland.ogc.swe.simpleType.SweTimeRange;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.encode.json.JSONEncoder;

public class FieldEncoder
extends JSONEncoder<SweField> {
    public FieldEncoder() {
        super(SweField.class, new EncoderKey[0]);
    }

    public JsonNode encodeJSON(SweField field) throws EncodingException {
        switch (field.getElement().getDataComponentType()) {
            case Count: {
                return this.encodeSweCountField(field);
            }
            case Boolean: {
                return this.encodeSweBooleanField(field);
            }
            case CountRange: {
                return this.encodeSweCountRangeField(field);
            }
            case ObservableProperty: {
                return this.encodeSweObservableProperyField(field);
            }
            case Text: {
                return this.encodeSweTextField(field);
            }
            case Quantity: {
                return this.encodeSweQuantityField(field);
            }
            case QuantityRange: {
                return this.encodeSweQuantityRangeField(field);
            }
            case Time: {
                return this.encodeSweTimeField(field);
            }
            case TimeRange: {
                return this.encodeSweTimeRangeField(field);
            }
            case Category: {
                return this.encodeSweCategoryField(field);
            }
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)field);
    }

    private ObjectNode createField(SweField field) {
        ObjectNode jfield = this.nodeFactory().objectNode();
        jfield.put("name", field.getName().getValue());
        SweAbstractDataComponent element = field.getElement();
        if (element.isSetDefinition()) {
            jfield.put("definition", element.getDefinition());
        }
        if (element.isSetDescription()) {
            jfield.put("description", element.getDescription());
        }
        if (element.isSetIdentifier()) {
            jfield.put("identifier", element.getIdentifier());
        }
        if (element.isSetLabel()) {
            jfield.put("label", element.getLabel());
        }
        return jfield;
    }

    private ObjectNode encodeSweCountField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "count");
        SweCount sweCount = (SweCount)field.getElement();
        if (sweCount.isSetValue()) {
            jfield.put("value", sweCount.getValue());
        }
        return jfield;
    }

    private ObjectNode encodeSweBooleanField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "boolean");
        SweBoolean sweBoolean = (SweBoolean)field.getElement();
        if (sweBoolean.isSetValue()) {
            jfield.put("value", sweBoolean.getValue());
        }
        return jfield;
    }

    private ObjectNode encodeSweCountRangeField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "countRange");
        SweCountRange sweCountRange = (SweCountRange)field.getElement();
        if (sweCountRange.isSetValue()) {
            ArrayNode av = jfield.putArray("value");
            av.add((Integer)sweCountRange.getValue().getRangeStart());
            av.add((Integer)sweCountRange.getValue().getRangeEnd());
        }
        return jfield;
    }

    private ObjectNode encodeSweObservableProperyField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "observableProperty");
        SweObservableProperty sweObservableProperty = (SweObservableProperty)field.getElement();
        if (sweObservableProperty.isSetValue()) {
            jfield.put("value", sweObservableProperty.getValue());
        }
        return jfield;
    }

    private ObjectNode encodeSweTextField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "text");
        SweText sweText = (SweText)field.getElement();
        if (sweText.isSetValue()) {
            jfield.put("value", sweText.getValue());
        }
        return jfield;
    }

    private ObjectNode encodeSweQuantityField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "quantity");
        SweQuantity sweQuantity = (SweQuantity)field.getElement();
        if (sweQuantity.isSetValue()) {
            jfield.put("value", sweQuantity.getValue());
        }
        jfield.put("uom", sweQuantity.getUom());
        return jfield;
    }

    private ObjectNode encodeSweQuantityRangeField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "quantityRange");
        SweQuantityRange sweQuantityRange = (SweQuantityRange)field.getElement();
        jfield.put("uom", sweQuantityRange.getUom());
        if (sweQuantityRange.isSetValue()) {
            ArrayNode av = jfield.putArray("value");
            av.add((Double)sweQuantityRange.getValue().getRangeStart());
            av.add((Double)sweQuantityRange.getValue().getRangeEnd());
        }
        return jfield;
    }

    private ObjectNode encodeSweTimeField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "time");
        SweTime sweTime = (SweTime)field.getElement();
        jfield.put("uom", sweTime.getUom());
        if (sweTime.isSetValue()) {
            jfield.put("value", DateTimeHelper.formatDateTime2IsoString((DateTime)sweTime.getValue()));
        }
        return jfield;
    }

    private ObjectNode encodeSweTimeRangeField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "timeRange");
        SweTimeRange sweTimeRange = (SweTimeRange)field.getElement();
        jfield.put("uom", sweTimeRange.getUom());
        if (sweTimeRange.isSetValue()) {
            ArrayNode av = jfield.putArray("value");
            av.add(DateTimeHelper.formatDateTime2IsoString((DateTime)((DateTime)sweTimeRange.getValue().getRangeStart())));
            av.add(DateTimeHelper.formatDateTime2IsoString((DateTime)((DateTime)sweTimeRange.getValue().getRangeEnd())));
        }
        return jfield;
    }

    private ObjectNode encodeSweCategoryField(SweField field) {
        ObjectNode jfield = this.createField(field);
        jfield.put("type", "category");
        SweCategory sweCategory = (SweCategory)field.getElement();
        jfield.put("codespace", sweCategory.getCodeSpace());
        if (sweCategory.isSetValue()) {
            jfield.put("value", sweCategory.getValue());
        }
        return jfield;
    }
}

