/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vividsolutions.jts.geom.Envelope;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.janmayen.i18n.MultilingualString;
import org.n52.shetland.ogc.filter.FilterCapabilities;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.ows.OwsAddress;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsContact;
import org.n52.shetland.ogc.ows.OwsDCP;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.ogc.ows.OwsDomainMetadata;
import org.n52.shetland.ogc.ows.OwsHttp;
import org.n52.shetland.ogc.ows.OwsKeyword;
import org.n52.shetland.ogc.ows.OwsLanguageString;
import org.n52.shetland.ogc.ows.OwsMetadata;
import org.n52.shetland.ogc.ows.OwsOnlineResource;
import org.n52.shetland.ogc.ows.OwsOperation;
import org.n52.shetland.ogc.ows.OwsOperationMetadataExtension;
import org.n52.shetland.ogc.ows.OwsOperationsMetadata;
import org.n52.shetland.ogc.ows.OwsPhone;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsRange;
import org.n52.shetland.ogc.ows.OwsRequestMethod;
import org.n52.shetland.ogc.ows.OwsResponsibleParty;
import org.n52.shetland.ogc.ows.OwsServiceIdentification;
import org.n52.shetland.ogc.ows.OwsServiceProvider;
import org.n52.shetland.ogc.ows.OwsValueRestriction;
import org.n52.shetland.ogc.ows.OwsValuesReference;
import org.n52.shetland.ogc.ows.OwsValuesUnit;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.SosOffering;
import org.n52.shetland.w3c.xlink.Link;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.json.AbstractSosResponseEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCapabilitiesResponseEncoder
extends AbstractSosResponseEncoder<GetCapabilitiesResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(GetCapabilitiesResponseEncoder.class);

    public GetCapabilitiesResponseEncoder() {
        super(GetCapabilitiesResponse.class, (Enum)SosConstants.Operations.GetCapabilities);
    }

    protected void encodeResponse(ObjectNode json, GetCapabilitiesResponse t) throws EncodingException {
        SosCapabilities caps = (SosCapabilities)t.getCapabilities();
        this.encodeOptional(json, "updateSequence", caps.getUpdateSequence(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "serviceIdentification", caps.getServiceIdentification(), this::encodeServiceIdentification);
        this.encodeOptional(json, "serviceProvider", caps.getServiceProvider(), this::encodeServiceProvider);
        this.encodeOptional(json, "operationMetadata", caps.getOperationsMetadata(), this::encodeOperationMetadata);
        this.encodeOptionalChecked(json, "contents", caps.getContents(), this::encodeContents);
        this.encodeExtensions(json, caps);
        this.encodeOptional(json, "filterCapabilities", caps.getFilterCapabilities(), this::encodeFilterCapabilities);
    }

    private void encodeMultilingualString(ObjectNode json, String name, Optional<MultilingualString> string) {
        string.ifPresent(t -> {
            ObjectNode title = json.putObject(name);
            t.forEach(ls -> json.put(LocaleHelper.encode((Locale)ls.getLang()), ls.getText()));
        });
    }

    public void encodeOwsLanguageString(ObjectNode json, OwsLanguageString ls) {
        json.put("value", ls.getValue());
        ls.getLang().ifPresent(lang -> json.put("lang", lang));
    }

    public ObjectNode encodeOwsKeyword(OwsKeyword keyword) {
        ObjectNode json = this.nodeFactory().objectNode();
        this.encodeOptional(json, "type", keyword.getType(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeOwsCode(arg_0));
        this.encodeOwsLanguageString(json, keyword.getKeyword());
        return json;
    }

    private ObjectNode encodeServiceProvider(OwsServiceProvider serviceProvider) {
        ObjectNode json = this.nodeFactory().objectNode();
        json.put("name", serviceProvider.getProviderName());
        this.encodeOptional(json, "site", serviceProvider.getProviderSite(), this::encodeOnlineResource);
        this.encode(json, "serviceContact", serviceProvider.getServiceContact(), this::encodeResponsibleParty);
        return json;
    }

    private JsonNode encodeResponsibleParty(OwsResponsibleParty responsibleParty) {
        ObjectNode json = this.nodeFactory().objectNode();
        this.encodeOptional(json, "individualName", responsibleParty.getIndividualName(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "organisationName", responsibleParty.getOrganisationName(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "positionName", responsibleParty.getPositionName(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "role", responsibleParty.getRole(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeOwsCode(arg_0));
        this.encodeOptional(json, "contactInfo", responsibleParty.getContactInfo(), this::encodeContact);
        return json;
    }

    private JsonNode encodeOnlineResource(OwsOnlineResource resource) {
        return this.encodeLink((Link)resource);
    }

    private ObjectNode encodeAddress(OwsAddress address) {
        ObjectNode json = this.nodeFactory().objectNode();
        this.encodeList(json, "deliveryPoint", address.getDeliveryPoint(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "city", address.getCity(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "postalCode", address.getPostalCode(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "administrativeArea", address.getAdministrativeArea(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "country", address.getCountry(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeList(json, "email", address.getElectronicMailAddress(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        return json;
    }

    private JsonNode encodePhone(OwsPhone phone) {
        ObjectNode node = this.nodeFactory().objectNode();
        this.encodeList(node, "voice", phone.getVoice(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeList(node, "facsimile", phone.getFacsimile(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        return node;
    }

    private ObjectNode encodeContact(OwsContact sp) {
        ObjectNode json = this.nodeFactory().objectNode();
        this.encodeOptional(json, "contactInstructions", sp.getContactInstructions(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "hoursOfService", sp.getHoursOfService(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(json, "address", sp.getAddress(), this::encodeAddress);
        this.encodeOptional(json, "onlineResource", sp.getOnlineResource(), this::encodeOnlineResource);
        this.encodeOptional(json, "phone", sp.getPhone(), this::encodePhone);
        return json;
    }

    private ObjectNode encodeFilterCapabilities(FilterCapabilities fc) {
        ObjectNode jfc = this.nodeFactory().objectNode();
        this.encodeFilterConformances(jfc, fc);
        this.encodeScalarCapabilities(jfc, fc);
        this.encode(jfc, "spatial", fc, this::encodeSpatialCapabilities);
        this.encode(jfc, "temporal", fc, this::encodeTemporalCapabilities);
        return jfc;
    }

    private void encodeFilterConformances(ObjectNode jfc, FilterCapabilities fc) {
    }

    private ArrayNode encodeOperands(SortedSet<QName> so) {
        return so.stream().map(this::qnameToSchema).filter(Objects::nonNull).map(schema -> this.nodeFactory().objectNode().put("$ref", schema)).collect(() -> ((JsonNodeFactory)this.nodeFactory()).arrayNode(), ArrayNode::add, ArrayNode::addAll);
    }

    private String qnameToSchema(QName qn) {
        if (qn.equals(GmlConstants.QN_TIME_INSTANT_32)) {
            return "http://www.52north.org/schema/json/TimeInstant#";
        }
        if (qn.equals(GmlConstants.QN_TIME_PERIOD_32)) {
            return "http://www.52north.org/schema/json/TimePeriod#";
        }
        if (qn.equals(GmlConstants.QN_ENVELOPE_32)) {
            return "http://www.52north.org/schema/json/Envelope#";
        }
        return null;
    }

    private ObjectNode encodeSpatialCapabilities(FilterCapabilities fc) {
        ObjectNode json = this.nodeFactory().objectNode();
        this.encode(json, "operands", fc.getSpatialOperands(), this::encodeOperands);
        this.encode(json, "operators", fc.getSpatialOperators(), this::encodeSpatialOperators);
        return json;
    }

    private ObjectNode encodeSpatialOperators(SortedMap<FilterConstants.SpatialOperator, SortedSet<QName>> operators) {
        ObjectNode json = this.nodeFactory().objectNode();
        operators.entrySet().forEach(so -> json.set(this.stringify((FilterConstants.SpatialOperator)so.getKey()), (JsonNode)this.encodeOperands((SortedSet)so.getValue())));
        return json;
    }

    private String stringify(FilterConstants.SpatialOperator so) {
        switch (so) {
            case Equals: {
                return "equals";
            }
            case Disjoint: {
                return "disjoint";
            }
            case Touches: {
                return "touches";
            }
            case Within: {
                return "within";
            }
            case Overlaps: {
                return "overlaps";
            }
            case Crosses: {
                return "crosses";
            }
            case Intersects: {
                return "intersects";
            }
            case Contains: {
                return "contains";
            }
            case DWithin: {
                return "dWithin";
            }
            case Beyond: {
                return "beyond";
            }
            case BBOX: {
                return "bbox";
            }
        }
        return so.name();
    }

    private String stringify(FilterConstants.TimeOperator to) {
        switch (to) {
            case TM_Before: {
                return "before";
            }
            case TM_After: {
                return "after";
            }
            case TM_Begins: {
                return "begins";
            }
            case TM_Ends: {
                return "ends";
            }
            case TM_EndedBy: {
                return "endedBy";
            }
            case TM_BegunBy: {
                return "begunBy";
            }
            case TM_During: {
                return "during";
            }
            case TM_Equals: {
                return "equals";
            }
            case TM_Contains: {
                return "contains";
            }
            case TM_Overlaps: {
                return "overlaps";
            }
            case TM_Meets: {
                return "meets";
            }
            case TM_MetBy: {
                return "metBy";
            }
            case TM_OverlappedBy: {
                return "overlappedby";
            }
        }
        return to.name();
    }

    private ObjectNode encodeTemporalCapabilities(FilterCapabilities fc) {
        ObjectNode json = this.nodeFactory().objectNode();
        this.encode(json, "operands", fc.getTemporalOperands(), this::encodeOperands);
        this.encode(json, "operators", fc.getTemporalOperators(), this::encodeTemporalOperators);
        return json;
    }

    private ObjectNode encodeTemporalOperators(SortedMap<FilterConstants.TimeOperator, SortedSet<QName>> operators) {
        ObjectNode json = this.nodeFactory().objectNode();
        operators.entrySet().forEach(so -> json.set(this.stringify((FilterConstants.TimeOperator)so.getKey()), (JsonNode)this.encodeOperands((SortedSet)so.getValue())));
        return json;
    }

    private void encodeScalarCapabilities(ObjectNode jfc, FilterCapabilities fc) {
        ObjectNode sfc = jfc.objectNode();
        if (sfc.size() > 0) {
            jfc.set("scalar", (JsonNode)sfc);
        }
    }

    private void encodeExtensions(ObjectNode json, SosCapabilities caps) {
    }

    private JsonNode encodeOffering(SosObservationOffering soo) throws EncodingException {
        ObjectNode jsoo = this.nodeFactory().objectNode();
        SosOffering offering = soo.getOffering();
        jsoo.put("identifier", offering.getIdentifier());
        if (offering.isSetName()) {
            jsoo.put("name", offering.getFirstName().getValue());
        }
        if (soo.isSetProcedures()) {
            jsoo.set("procedure", (JsonNode)soo.getProcedures().stream().map(arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0)).collect(this.toJsonArray()));
        }
        if (soo.isSetObservableProperties()) {
            jsoo.set("observableProperty", (JsonNode)soo.getObservableProperties().stream().map(arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0)).collect(this.toJsonArray()));
        }
        if (soo.isSetRelatedFeature()) {
            ArrayNode jrf = jsoo.putArray("relatedFeature");
            soo.getRelatedFeatures().forEach((feature, roles) -> jrf.addObject().put("featureOfInterest", feature).set("role", (JsonNode)roles.stream().map(arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0)).collect(this.toJsonArray())));
        }
        if (soo.isSetObservedArea() && soo.getObservedArea().isSetEnvelope() && soo.getObservedArea().isSetSrid()) {
            Envelope e = soo.getObservedArea().getEnvelope();
            ObjectNode oa = jsoo.putObject("observedArea");
            oa.putArray("lowerLeft").add(e.getMinX()).add(e.getMinY());
            oa.putArray("upperRight").add(e.getMaxX()).add(e.getMaxY());
            oa.putObject("crs").put("type", "link").putObject("properties").put("href", "http://www.opengis.net/def/crs/EPSG/0/" + soo.getObservedArea().getSrid());
        }
        if (soo.isSetPhenomenonTime()) {
            jsoo.set("phenomenonTime", this.encodeObjectToJson(soo.getPhenomenonTime()));
        }
        if (soo.isSetResultTime()) {
            jsoo.set("resultTime", this.encodeObjectToJson(soo.getResultTime()));
        }
        if (soo.isSetResponseFormats()) {
            jsoo.set("responseFormat", (JsonNode)soo.getResponseFormats().stream().map(arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0)).collect(this.toJsonArray()));
        }
        if (soo.isSetObservationTypes()) {
            jsoo.set("observationType", (JsonNode)soo.getObservationTypes().stream().map(arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0)).collect(this.toJsonArray()));
        }
        if (soo.isSetFeatureOfInterestTypes()) {
            jsoo.set("featureOfInterestType", (JsonNode)soo.getFeatureOfInterestTypes().stream().map(arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0)).collect(this.toJsonArray()));
        }
        if (soo.isSetProcedureDescriptionFormats()) {
            jsoo.set("procedureDescriptionFormat", (JsonNode)soo.getProcedureDescriptionFormats().stream().map(arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0)).collect(this.toJsonArray()));
        }
        return jsoo;
    }

    private JsonNode encodeOperationMetadata(OwsOperationsMetadata operationsMetadata) {
        ObjectNode node = this.nodeFactory().objectNode();
        this.encodeList(node, "operations", operationsMetadata.getOperations(), this::encodeOperation);
        this.encodeList(node, "constraints", operationsMetadata.getConstraints(), this::encodeOwsDomain);
        this.encodeList(node, "parameters", operationsMetadata.getParameters(), this::encodeOwsDomain);
        this.encodeOptional(node, "extensions", operationsMetadata.getExtension(), this::encodeOwsOperationMetadataExtension);
        return node;
    }

    private JsonNode encodeOwsOperationMetadataExtension(OwsOperationMetadataExtension operationMetadataExtension) {
        return this.nodeFactory().nullNode();
    }

    private JsonNode encodeOperation(OwsOperation o) {
        ObjectNode jo = this.nodeFactory().objectNode();
        jo.put("name", o.getName());
        this.encodeList(jo, "parameters", o.getParameters(), this::encodeOwsDomain);
        this.encodeList(jo, "constraints", o.getConstraints(), this::encodeOwsDomain);
        this.encodeList(jo, "metadata", o.getMetadata(), this::encodeOwsMetadata);
        this.encodeList(jo, "dcp", o.getDCP(), this::encodeOwsDCP);
        return jo;
    }

    private JsonNode encodeOwsDCP(OwsDCP dcp) {
        if (dcp.isHTTP()) {
            return this.encodeOwsHTTP(dcp.asHTTP());
        }
        return this.nodeFactory().nullNode();
    }

    private JsonNode encodeOwsMetadata(OwsMetadata metadata) {
        ObjectNode node = this.encodeLink((Link)metadata);
        this.encodeOptional(node, "about", metadata.getAbout(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeURI(arg_0));
        return node;
    }

    private JsonNode encodeOwsDomainMetadata(OwsDomainMetadata metadata) {
        ObjectNode node = this.nodeFactory().objectNode();
        this.encodeOptional(node, "reference", metadata.getReference(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeURI(arg_0));
        this.encodeOptional(node, "value", metadata.getValue(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeAsString(arg_0));
        return node;
    }

    private ObjectNode encodeLink(Link link) {
        ObjectNode node = this.nodeFactory().objectNode();
        this.encodeOptional(node, "$ref", link.getHref(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeURI(arg_0));
        this.encodeOptional(node, "title", link.getTitle(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeOptional(node, "actuate", link.getActuate(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeAsString(arg_0));
        this.encodeOptional(node, "arcrole", link.getArcrole(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeURI(arg_0));
        this.encodeOptional(node, "role", link.getRole(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeURI(arg_0));
        this.encodeOptional(node, "show", link.getShow(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeAsString(arg_0));
        return node;
    }

    private JsonNode encodeOwsDomain(OwsDomain domain) {
        ObjectNode node = this.nodeFactory().objectNode();
        this.encode(node, "name", domain.getName(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeAsString(arg_0));
        this.encodeOptional(node, "dataType", domain.getDataType(), this::encodeOwsDomainMetadata);
        this.encodeOptional(node, "default", domain.getDefaultValue(), this::encodeOwsValue);
        this.encodeOptional(node, "meaning", domain.getMeaning(), this::encodeOwsDomainMetadata);
        this.encodeOptional(node, "metadata", domain.getMeaning(), this::encodeOwsDomainMetadata);
        this.encode(node, "possibleValues", domain.getPossibleValues(), this::encodeParameterPossibleValues);
        domain.getValuesUnit().ifPresent(unit -> {
            JsonNode json = this.encodeOwsValuesUnit((OwsValuesUnit)unit);
            if (unit.isReferenceSystem()) {
                node.set("referenceSystem", json);
            } else if (unit.isUOM()) {
                node.set("uom", json);
            }
        });
        this.encodeOptional(node, "valuesUnit", domain.getValuesUnit(), this::encodeOwsValuesUnit);
        return node;
    }

    private JsonNode encodeOwsValuesUnit(OwsValuesUnit unit) {
        ObjectNode node = this.nodeFactory().objectNode();
        this.encodeOptional(node, "reference", unit.getReference(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeURI(arg_0));
        this.encodeOptional(node, "value", unit.getValue(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeAsString(arg_0));
        return node;
    }

    private JsonNode encodeParameterPossibleValues(OwsPossibleValues parameterValue) {
        if (parameterValue.isAnyValue()) {
            return this.nodeFactory().textNode("any");
        }
        if (parameterValue.isNoValues()) {
            return this.nodeFactory().textNode("none");
        }
        if (parameterValue.isAllowedValues()) {
            return this.encodeOwsAllowedValues(parameterValue.asAllowedValues());
        }
        if (parameterValue.isValuesReference()) {
            return this.encodeOwsValueReference(parameterValue.asValuesReference());
        }
        LOG.warn("Unsupported OwsParameterValue type: {}", parameterValue.getClass());
        return this.nodeFactory().nullNode();
    }

    private ObjectNode encodeServiceIdentification(OwsServiceIdentification serviceIdentification) {
        ObjectNode json = this.nodeFactory().objectNode();
        this.encodeMultilingualString(json, "title", serviceIdentification.getTitle());
        this.encodeMultilingualString(json, "abstract", serviceIdentification.getAbstract());
        this.encodeList(json, "accessConstraints", serviceIdentification.getAccessConstraints(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encodeList(json, "fees", serviceIdentification.getFees(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        this.encode(json, "serviceType", serviceIdentification.getServiceType(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeOwsCode(arg_0));
        this.encodeList(json, "keywords", serviceIdentification.getKeywords(), this::encodeOwsKeyword);
        this.encodeList(json, "profiles", serviceIdentification.getProfiles(), arg_0 -> ((GetCapabilitiesResponseEncoder)this).encodeURI(arg_0));
        this.encodeList(json, "versions", serviceIdentification.getServiceTypeVersion(), arg_0 -> ((JsonNodeFactory)this.nodeFactory()).textNode(arg_0));
        return json;
    }

    private JsonNode encodeOwsValue(OwsValueRestriction restriction) {
        return this.nodeFactory().textNode(restriction.asValue().getValue());
    }

    private JsonNode encodeOwsRange(OwsValueRestriction restriction) {
        OwsRange range = restriction.asRange();
        ObjectNode json = this.nodeFactory().objectNode();
        this.encodeOptional(json, "min", range.getLowerBound(), this::encodeOwsValue);
        this.encodeOptional(json, "max", range.getUpperBound(), this::encodeOwsValue);
        json.set("type", (JsonNode)this.nodeFactory().textNode(range.getType()));
        this.encodeOptional(json, "spacing", range.getSpacing(), this::encodeOwsValue);
        return json;
    }

    public JsonNode encodeOwsAllowedValues(OwsAllowedValues allowedValues) {
        return (JsonNode)allowedValues.getRestrictions().stream().map(this::encodeOwsValueRestriction).collect(() -> ((JsonNodeFactory)this.nodeFactory()).arrayNode(), ArrayNode::add, ArrayNode::addAll);
    }

    public JsonNode encodeOwsValueReference(OwsValuesReference valuesReference) {
        ObjectNode node = this.nodeFactory().objectNode();
        node.put("reference", valuesReference.getReference().toString());
        node.put("value", valuesReference.getValue());
        return node;
    }

    private JsonNode encodeOwsHTTP(OwsHttp http) {
        ObjectNode node = this.nodeFactory().objectNode();
        node.put("type", "HTTP");
        node.set("methods", (JsonNode)http.getRequestMethods().stream().collect(this.toJsonObject(Collectors.groupingBy(OwsRequestMethod::getHttpMethod, Collectors.mapping(this::encodeOwsRequestMethod, this.toJsonArray())))));
        return node;
    }

    public ObjectNode encodeOwsRequestMethod(OwsRequestMethod m) {
        ObjectNode jm = this.encodeLink((Link)m);
        this.encodeList(jm, "constraints", m.getConstraints(), this::encodeOwsDomain);
        return jm;
    }

    public JsonNode encodeOwsValueRestriction(OwsValueRestriction restriction) {
        Object n = restriction.isValue() ? this.encodeOwsValue(restriction) : (restriction.isRange() ? this.encodeOwsRange((OwsValueRestriction)restriction.asRange()) : this.nodeFactory().nullNode());
        return n;
    }

    private JsonNode encodeContents(SortedSet<SosObservationOffering> contents) throws EncodingException {
        ArrayNode node = this.nodeFactory().arrayNode();
        for (SosObservationOffering offering : contents) {
            node.add(this.encodeOffering(offering));
        }
        return node;
    }
}

