/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Set;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.json.AbstractSosResponseEncoder;

public class GetDataAvailabilityJsonEncoder
extends AbstractSosResponseEncoder<GetDataAvailabilityResponse> {
    public GetDataAvailabilityJsonEncoder() {
        super(GetDataAvailabilityResponse.class, "GetDataAvailability");
    }

    protected void encodeResponse(ObjectNode json, GetDataAvailabilityResponse t) throws EncodingException {
        ArrayNode a = json.putArray("dataAvailability");
        for (GetDataAvailabilityResponse.DataAvailability da : t.getDataAvailabilities()) {
            ObjectNode objectNode = a.addObject();
            objectNode.put("featureOfInterest", da.getFeatureOfInterest().getHref()).put("procedure", da.getProcedure().getHref()).put("observedProperty", da.getObservedProperty().getHref()).set("phenomenonTime", this.encodeObjectToJson(da.getPhenomenonTime()));
            if (t.isSetResponseFormat() && "http://www.opengis.net/sosgda/2.0".equals(t.getResponseFormat())) {
                if (da.isSetOffering()) {
                    objectNode.put("offering", da.getOffering().getHref());
                }
                if (da.isSetFormatDescriptors()) {
                    ObjectNode fdNode = objectNode.putObject("formatDescriptor");
                    this.encodeProcedureFormatDescriptor(da.getFormatDescriptor().getProcedureDescriptionFormatDescriptor(), fdNode);
                    this.encodeObservationFormatDescriptor(da.getFormatDescriptor().getObservationFormatDescriptors(), fdNode);
                }
            }
            if (!da.isSetCount()) continue;
            objectNode.put("count", da.getCount());
        }
    }

    private void encodeProcedureFormatDescriptor(GetDataAvailabilityResponse.ProcedureDescriptionFormatDescriptor procedureDescriptionFormatDescriptor, ObjectNode fdNode) {
        ObjectNode pfdNode = fdNode.putObject("procedureDescriptionFormatDescriptor");
        pfdNode.put("procedureDescriptionFormat", procedureDescriptionFormatDescriptor.getProcedureDescriptionFormat());
    }

    private void encodeObservationFormatDescriptor(Set<GetDataAvailabilityResponse.ObservationFormatDescriptor> observationFormatDescriptors, ObjectNode fdNode) {
        ArrayNode ofdArray = fdNode.putArray("observationFormatDescriptor");
        for (GetDataAvailabilityResponse.ObservationFormatDescriptor ofd : observationFormatDescriptors) {
            ObjectNode ofdNode = ofdArray.addObject();
            ofdNode.put("responseFormat", ofd.getResponseFormat());
            ArrayNode otArray = ofdNode.putArray("observationType");
            for (String obsType : ofd.getObservationTypes()) {
                otArray.add(obsType);
            }
        }
    }
}

